/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes.selectable;

import de.proveo.idm.core.gui.navigation.filter.NavigationFilter;
import de.proveo.idm.remote.server.navigation.nodes.AggregateFilterNode;
import de.proveo.idm.remote.server.navigation.nodes.selectable.SelectableNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class SelectionChangedListener
implements PropertyChangeListener {
    private Node originalGroupNode = null;
    private AggregateFilterNode groupNode;

    public SelectionChangedListener(AggregateFilterNode groupNode) {
        this.groupNode = groupNode;
        this.originalGroupNode = this.groupNode;
        while (this.originalGroupNode instanceof AggregateFilterNode) {
            this.originalGroupNode = ((AggregateFilterNode)this.originalGroupNode).getOriginal();
        }
    }

    private Boolean checkChildrenSelectionOfNode(Node groupNode, boolean includingInvisible) {
        if (includingInvisible && groupNode instanceof AggregateFilterNode) {
            groupNode = ((AggregateFilterNode)groupNode).getOriginal();
        }
        boolean someSelected = false;
        boolean someDeselected = false;
        Children children = groupNode.getChildren();
        for (int i = 0; i < children.getNodesCount(); ++i) {
            Node child = children.getNodeAt(i);
            while (includingInvisible && child instanceof AggregateFilterNode) {
                child = ((AggregateFilterNode)child).getOriginal();
            }
            SelectableNode checkNode = (SelectableNode)child.getLookup().lookup(SelectableNode.class);
            if (checkNode != null) {
                if (Boolean.TRUE.equals(checkNode.isSelected())) {
                    someSelected = true;
                } else if (Boolean.FALSE.equals(checkNode.isSelected())) {
                    someDeselected = true;
                } else {
                    someSelected = true;
                    someDeselected = true;
                    break;
                }
            }
            if (child.isLeaf()) continue;
            Boolean childSelection = this.checkChildrenSelectionOfNode(child, includingInvisible);
            if (childSelection == null) {
                return childSelection;
            }
            if (Boolean.TRUE.equals(childSelection)) {
                someSelected = true;
                continue;
            }
            if (!Boolean.FALSE.equals(childSelection)) continue;
            someDeselected = true;
        }
        Boolean selected = null;
        if (!someSelected) {
            selected = Boolean.FALSE;
        } else if (!someDeselected) {
            selected = Boolean.TRUE;
        }
        return selected;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectableNode.selectionChanged".equals(evt.getPropertyName())) {
            Boolean selected;
            Node parentNode;
            Boolean selectedIncludingInvisible;
            Boolean selectedExcludingInvisible;
            Boolean wasSelected = null;
            Object oldValue = evt.getOldValue();
            if (oldValue != null) {
                wasSelected = Boolean.parseBoolean(oldValue.toString());
            }
            Boolean isSelected = null;
            Object newValue = evt.getNewValue();
            if (newValue != null) {
                isSelected = Boolean.parseBoolean(newValue.toString());
            }
            if (!this.groupNode.isLeaf() && ObjectUtils.notEqual((Object)(selectedExcludingInvisible = this.checkChildrenSelectionOfNode((Node)this.groupNode, false)), (Object)(selectedIncludingInvisible = this.checkChildrenSelectionOfNode((Node)this.groupNode, true)))) {
                isSelected = selectedExcludingInvisible == null ? Boolean.TRUE : selectedExcludingInvisible == false;
                wasSelected = isSelected == false;
            }
            if (isSelected != null && !isSelected.equals(wasSelected)) {
                this.setChildrenOfNodeSelected((Node)this.groupNode, isSelected);
            }
            for (parentNode = this.groupNode.getParentNode(); parentNode != null; parentNode = parentNode.getParentNode()) {
                Node originalParentNode = parentNode;
                while (originalParentNode instanceof AggregateFilterNode) {
                    originalParentNode = ((AggregateFilterNode)originalParentNode).getOriginal();
                }
                Boolean selected2 = this.checkChildrenSelectionOfNode(parentNode, true);
                if (!ObjectUtils.notEqual((Object)selected2, (Object)((SelectableNode)originalParentNode.getLookup().lookup(SelectableNode.class)).isSelected())) continue;
                ((SelectableNode)originalParentNode.getLookup().lookup(SelectableNode.class)).setSelectedWithoutNotify(selected2);
                if (!(parentNode instanceof AggregateFilterNode)) continue;
                ((AggregateFilterNode)parentNode).fireNodeChanged();
            }
            if (!this.groupNode.isLeaf() && ObjectUtils.notEqual((Object)(selected = this.checkChildrenSelectionOfNode((Node)this.groupNode, true)), (Object)((SelectableNode)this.originalGroupNode.getLookup().lookup(SelectableNode.class)).isSelected())) {
                ((SelectableNode)this.originalGroupNode.getLookup().lookup(SelectableNode.class)).setSelectedWithoutNotify(selected);
                if (parentNode instanceof AggregateFilterNode) {
                    this.groupNode.fireNodeChanged();
                }
            }
        }
    }

    private void setChildrenOfNodeSelected(Node groupNode, Boolean selected) {
        Children children = groupNode.getChildren();
        for (int i = 0; i < children.getNodesCount(true); ++i) {
            Node childNode;
            Node originalChildNode = childNode = children.getNodeAt(i);
            while (originalChildNode instanceof AggregateFilterNode) {
                originalChildNode = ((AggregateFilterNode)originalChildNode).getOriginal();
            }
            NavigationFilter filter = null;
            if (groupNode instanceof AggregateFilterNode) {
                filter = ((AggregateFilterNode)groupNode).getNavigationFilter();
            }
            if (filter != null && !filter.filter((Object)childNode.getDisplayName()) && !filter.isViable(childNode)) continue;
            SelectableNode checkNode = (SelectableNode)originalChildNode.getLookup().lookup(SelectableNode.class);
            if (checkNode != null) {
                checkNode.setSelectedWithoutNotify(selected);
                if (childNode instanceof AggregateFilterNode) {
                    ((AggregateFilterNode)childNode).fireNodeChanged();
                }
            }
            if (childNode.isLeaf()) continue;
            this.setChildrenOfNodeSelected(childNode, selected);
        }
    }
}

