/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes.selectable;

import de.proveo.idm.remote.server.navigation.nodes.AggregateFilterNode;
import de.proveo.idm.remote.server.navigation.nodes.selectable.SelectableNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ChildrenSelectionChangedListener
implements PropertyChangeListener {
    private Node node;

    public ChildrenSelectionChangedListener(Node node) {
        this.node = node;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectableNode.selectionChanged".equals(evt.getPropertyName())) {
            for (Node groupNode = this.node.getParentNode(); groupNode != null; groupNode = groupNode.getParentNode()) {
                Boolean selected = this.checkChildrenSelectionOfNode(groupNode);
                if (!ObjectUtils.notEqual((Object)selected, (Object)((SelectableNode)groupNode.getLookup().lookup(SelectableNode.class)).isSelected())) continue;
                ((SelectableNode)groupNode.getLookup().lookup(SelectableNode.class)).setSelectedWithoutNotify(selected);
                if (!(groupNode instanceof AggregateFilterNode)) continue;
                ((AggregateFilterNode)groupNode).fireNodeChanged();
            }
        }
    }

    private Boolean checkChildrenSelectionOfNode(Node groupNode) {
        if (groupNode instanceof AggregateFilterNode) {
            groupNode = ((AggregateFilterNode)groupNode).getOriginal();
        }
        boolean someSelected = false;
        boolean someDeselected = false;
        Children children = groupNode.getChildren();
        for (int i = 0; i < children.getNodesCount(); ++i) {
            SelectableNode checkNode;
            Node child = children.getNodeAt(i);
            if (child instanceof AggregateFilterNode) {
                child = ((AggregateFilterNode)child).getOriginal();
            }
            if ((checkNode = (SelectableNode)child.getLookup().lookup(SelectableNode.class)) != null) {
                if (Boolean.TRUE.equals(checkNode.isSelected())) {
                    someSelected = true;
                } else if (Boolean.FALSE.equals(checkNode.isSelected())) {
                    someDeselected = true;
                } else {
                    someSelected = true;
                    someDeselected = true;
                    break;
                }
            }
            if (child.isLeaf()) continue;
            Boolean childSelection = this.checkChildrenSelectionOfNode(child);
            if (childSelection == null) {
                return childSelection;
            }
            if (Boolean.TRUE.equals(childSelection)) {
                someSelected = true;
                continue;
            }
            if (!Boolean.FALSE.equals(childSelection)) continue;
            someDeselected = true;
        }
        Boolean selected = null;
        if (!someSelected) {
            selected = Boolean.FALSE;
        } else if (!someDeselected) {
            selected = Boolean.TRUE;
        }
        return selected;
    }
}

