/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes.selectable;

import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.navigation.nodes.selectable.CheckableRemoteGroupNode;
import de.proveo.idm.remote.server.navigation.nodes.selectable.CheckableRemoteInfomanNode;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class CheckableRemoteGroupItemChildren
extends Children.Keys<NavigationItem> {
    private final NavigationItem navigationItem;
    private Device.DeviceType[] deviceTypeFilters;

    public CheckableRemoteGroupItemChildren(NavigationItem navigationItem, Device.DeviceType ... deviceTypeFilters) {
        this.navigationItem = navigationItem;
        this.deviceTypeFilters = deviceTypeFilters;
        if (this.deviceTypeFilters == null || this.deviceTypeFilters.length == 0) {
            this.deviceTypeFilters = new Device.DeviceType[]{Device.DeviceType.ANY};
        }
    }

    protected void addNotify() {
        super.addNotify();
        this.setKeys(this.navigationItem.getChildren());
    }

    protected Node[] createNodes(NavigationItem key) {
        AbstractNode node = null;
        if (key instanceof RemoteInfoman) {
            RemoteInfoman infoman = (RemoteInfoman)key;
            if (this.isAllowedRemoteInfoman(infoman, this.deviceTypeFilters)) {
                node = new CheckableRemoteInfomanNode((RemoteInfoman)key);
            }
        } else if (this.containsNavigationItemRemoteInfomansForDeviceTypes(key, this.deviceTypeFilters)) {
            node = new CheckableRemoteGroupNode(key, this.deviceTypeFilters);
        }
        if (node != null) {
            return new Node[]{node};
        }
        return null;
    }

    private boolean containsNavigationItemRemoteInfomansForDeviceTypes(NavigationItem item, Device.DeviceType ... deviceTypes) {
        List childItems = item.getChildren();
        for (NavigationItem childItem : childItems) {
            RemoteInfoman infoman;
            if (!(childItem instanceof RemoteInfoman ? this.isAllowedRemoteInfoman(infoman = (RemoteInfoman)childItem, deviceTypes) : this.containsNavigationItemRemoteInfomansForDeviceTypes(childItem, deviceTypes))) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowedRemoteInfoman(RemoteInfoman infoman, Device.DeviceType ... deviceTypes) {
        Device.DeviceType devType = infoman.getDeviceType();
        if (devType == null) {
            devType = Device.DeviceType.INFOMAN;
        }
        return ArrayUtils.contains((Object[])deviceTypes, (Object)Device.DeviceType.ANY) || ArrayUtils.contains((Object[])deviceTypes, (Object)devType);
    }
}

