/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.Connectable;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.sheet.ReadOnlyProperty;
import de.proveo.idm.core.gui.util.MenuUtil;
import de.proveo.idm.remote.server.api.AbstractRemoteInfoman;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.navigation.nodes.TaskChildFactory;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public class RemoteInfomanNode
extends AbstractNode {
    private static final Logger log = Logger.getLogger(RemoteInfomanNode.class.getName());
    protected static final Image VISIBLE_ON_MAP_OVERLAY = ImageUtilities.loadImage((String)"de/proveo/idm/remote/server/resources/map_overlay.png");
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
    protected final Object iconImageLock = new Object();
    protected String actionPath = "Actions/Remote/";
    protected volatile boolean positionPresent = true;
    protected volatile boolean visibleOnMap = false;
    protected Image iconImage = null;
    private PropertyChangeListener listener;

    public RemoteInfomanNode(RemoteInfoman infoman) {
        this(infoman, RemoteInfomanNode.createChildren(infoman), Lookups.singleton((Object)infoman));
        RemoteUpdateAdapter adapter = infoman.getServer().getRemoteUpdateAdapter();
        this.listener = new PropertyChangeListenerImpl();
        adapter.addPropertyChangeListener(this.listener);
    }

    protected RemoteInfomanNode(RemoteInfoman infoman, Children children, Lookup lookup) {
        super(children, lookup);
        Device.DeviceType deviceType = infoman.getDeviceType();
        if (deviceType == null) {
            this.actionPath = this.actionPath + "Infoman";
        } else if (deviceType.equals((Object)Device.DeviceType.INFOMAN)) {
            this.actionPath = this.actionPath + "Infoman";
        } else if (deviceType.equals((Object)Device.DeviceType.INFOMAN_EFM)) {
            this.actionPath = this.actionPath + "InfomanLite";
        } else if (deviceType.equals((Object)Device.DeviceType.ERCO_GENER)) {
            this.actionPath = this.actionPath + "ErcoGener";
        } else if (deviceType.equals((Object)Device.DeviceType.TK_CHEL)) {
            this.actionPath = this.actionPath + "TKChel";
        } else if (deviceType.equals((Object)Device.DeviceType.TELIC)) {
            this.actionPath = this.actionPath + "Telic";
        } else if (deviceType.equals((Object)Device.DeviceType.GPS_VISION)) {
            this.actionPath = this.actionPath + "GPSVision";
        } else if (deviceType.equals((Object)Device.DeviceType.OMNICOM)) {
            this.actionPath = this.actionPath + "Omnicom";
        } else if (deviceType.equals((Object)Device.DeviceType.NOMO)) {
            this.actionPath = this.actionPath + "NoMo";
        } else {
            log.log(Level.WARNING, "Unknown device type found for unit ''{0}'': {1}", new Object[]{infoman.getName(), deviceType});
            this.actionPath = this.actionPath + "Unknown";
        }
        this.iconImage = ImageUtilities.loadImage((String)infoman.getIconBaseWithExtension());
        this.setDisplayName(infoman.getName());
    }

    public void destroy() throws IOException {
        AbstractRemoteInfoman infoman;
        if (this.listener != null && (infoman = (AbstractRemoteInfoman)this.getLookup().lookup(AbstractRemoteInfoman.class)) != null) {
            RemoteUpdateAdapter adapter = infoman.getServer().getRemoteUpdateAdapter();
            adapter.removePropertyChangeListener(this.listener);
        }
        super.destroy();
    }

    public String getHtmlDisplayName() {
        return "<font color=\"#" + (this.positionPresent ? "000000" : "bbbbbb") + "\">" + this.getDisplayName() + "</font>";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Image getIcon(int type) {
        Image image = this.iconImage;
        if (image == null) {
            this.iconImage = image = super.getIcon(type);
        }
        Object object = this.iconImageLock;
        synchronized (object) {
            if (image != null && !this.positionPresent) {
                image = ImageUtilities.createDisabledImage((Image)image);
                Icon tmpIcon = ImageUtilities.image2Icon((Image)image);
                image = ImageUtilities.icon2Image((Icon)tmpIcon);
            }
            if (image != null && this.visibleOnMap) {
                image = ImageUtilities.mergeImages((Image)image, (Image)VISIBLE_ON_MAP_OVERLAY, (int)0, (int)0);
            }
        }
        return image;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action getPreferredAction() {
        Action action = super.getPreferredAction();
        Action[] actions = this.getActions(false);
        if (actions != null && actions.length > 0) {
            for (Action a : actions) {
                if (a == null) continue;
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(super.getLookup());
                }
                if (!a.isEnabled() || a instanceof Presenter) continue;
                action = a;
                break;
            }
        }
        return action;
    }

    protected synchronized Sheet createSheet() {
        final Sheet sheet = super.createSheet();
        final RemoteInfoman infoman = (RemoteInfoman)this.getLookup().lookup(RemoteInfoman.class);
        Sheet.Set propSet = Sheet.createPropertiesSet();
        propSet.setName("props");
        propSet.setDisplayName(NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.set.props"));
        sheet.put(propSet);
        Object value = infoman.getUnitId();
        if (value.toString().trim().length() == 0) {
            value = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.unknown");
        }
        ReadOnlyProperty property = new ReadOnlyProperty("unitId", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.unitId"), value);
        propSet.put((Node.Property)property);
        value = infoman.getName();
        if (value == null || value.toString().trim().length() == 0) {
            value = "";
        }
        property = new ReadOnlyProperty("unitName", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.unitName"), value);
        propSet.put((Node.Property)property);
        value = infoman.getSerialNumber();
        if (value == null || value.toString().trim().length() == 0) {
            value = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.na");
        }
        property = new ReadOnlyProperty("serialNo", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.serialNo"), value);
        propSet.put((Node.Property)property);
        if (infoman instanceof Connectable) {
            value = ((Connectable)infoman).getIPAddress();
            if (value == null || value.toString().trim().length() == 0) {
                value = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.na");
            }
            property = new ReadOnlyProperty("ipAddress", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.ipAddress"), value);
            propSet.put((Node.Property)property);
        }
        if ((value = infoman.getDeviceType()) == null || value.toString().trim().length() == 0) {
            value = NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.unknown") + " (" + NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.value.assuming") + " " + Device.DeviceType.INFOMAN.toString() + ")";
        }
        property = new ReadOnlyProperty("deviceType", NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.attribute.deviceType"), value);
        propSet.put((Node.Property)property);
        new Thread(){

            @Override
            public void run() {
                try {
                    sheet.put(RemoteInfomanNode.this.createEnvironmentSheet(infoman));
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "RemoteInfomanNode.createEnvironmentSheet() runs into", ex);
                }
            }
        }.start();
        return sheet;
    }

    protected synchronized void refreshEnvironmentSheet() {
        new Thread(){

            @Override
            public void run() {
                RemoteInfoman infoman = (RemoteInfoman)RemoteInfomanNode.this.getLookup().lookup(RemoteInfoman.class);
                try {
                    Sheet.Set current = RemoteInfomanNode.this.getSheet().get("env");
                    if (current != null) {
                        Sheet.Set newSet = RemoteInfomanNode.this.createEnvironmentSheet(infoman);
                        Node.Property[] props = newSet.getProperties();
                        current.put(props);
                        RemoteInfomanNode.this.firePropertySetsChange(null, new Node.PropertySet[]{newSet});
                    }
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, "RemoteInfomanNode.refreshEnvironmentSheet() runs into", ex);
                }
            }
        }.start();
    }

    protected Sheet.Set createEnvironmentSheet(RemoteInfoman infoman) throws Exception {
        Sheet.Set setProps = Sheet.createPropertiesSet();
        setProps.setName("env");
        setProps.setValue("tabName", (Object)NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.tab.env"));
        setProps.setDisplayName(NbBundle.getMessage(RemoteInfomanNode.class, (String)"RemoteInfomanNode.set.env"));
        SortedMap env = infoman.getEnv();
        if (env != null) {
            for (String key : env.keySet()) {
                String description;
                try {
                    description = NbBundle.getMessage(RemoteInfoman.class, (String)key);
                }
                catch (MissingResourceException ex) {
                    description = key;
                    log.log(Level.WARNING, "No resource for key: " + key, ex);
                }
                Object value = env.get(key);
                if (key.equals("request_config_time") || key.equals("sync_time")) {
                    long timestamp = 0L;
                    if (value != null) {
                        try {
                            timestamp = Long.parseLong(value.toString());
                        }
                        catch (NumberFormatException ex) {
                            timestamp = 0L;
                        }
                    }
                    value = NbBundle.getMessage(RemoteInfomanNode.class, (String)"timestamp.never");
                    if (timestamp > 0L) {
                        value = DATE_FORMAT.format(new Date(timestamp));
                    }
                }
                ReadOnlyProperty property = new ReadOnlyProperty(key, description, value);
                setProps.put((Node.Property)property);
            }
        }
        return setProps;
    }

    protected static Children createChildren(RemoteInfoman infoman) {
        Children children;
        block5: {
            RemoteUpdateAdapter adapter = infoman.getServer().getRemoteUpdateAdapter();
            if (!(infoman instanceof CheckableNode) && adapter.hasTasks()) {
                try {
                    RemoteDeviceId id = infoman.getId();
                    Collection<DatasyncTaskValue> tasks = adapter.getTasks(id);
                    if (tasks.isEmpty()) {
                        children = Children.LEAF;
                        break block5;
                    }
                    children = Children.create((ChildFactory)new TaskChildFactory(infoman, adapter, id), (boolean)true);
                }
                catch (Exception ex) {
                    children = Children.LEAF;
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                children = Children.LEAF;
            }
        }
        return children;
    }

    public Action[] getActions(boolean context) {
        this.refreshEnvironmentSheet();
        ArrayList actions = new ArrayList();
        List registeredActions = new ArrayList();
        try {
            registeredActions = MenuUtil.actionsForPaths((String[])new String[]{this.actionPath});
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        List<Action> superActions = Arrays.asList(super.getActions(context));
        actions.addAll(registeredActions);
        actions.addAll(superActions);
        return actions.toArray(new Action[actions.size()]);
    }

    private class PropertyChangeListenerImpl
    implements PropertyChangeListener {
        private PropertyChangeListenerImpl() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            if (property.equals("RemoteUpdateAdapter.task.create") || property.equals("RemoteUpdateAdapter.task.cancel") || property.equals("RemoteUpdateAdapter.task.edit")) {
                DatasyncTaskValue task = (DatasyncTaskValue)evt.getNewValue();
                final AbstractRemoteInfoman infoman = (AbstractRemoteInfoman)RemoteInfomanNode.this.getLookup().lookup(AbstractRemoteInfoman.class);
                if (infoman.getUnitId() == task.getClientId()) {
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                NavigationTopComponent nav = NavigationTopComponent.findInstance();
                                boolean expanded = nav.isNodeExpanded((Node)RemoteInfomanNode.this);
                                RemoteInfomanNode.this.setChildren(RemoteInfomanNode.createChildren(infoman));
                                if (expanded) {
                                    nav.expandNode((Node)RemoteInfomanNode.this);
                                }
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        run.run();
                    } else {
                        SwingUtilities.invokeLater(run);
                    }
                }
            }
        }
    }
}

