/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.remote.server.util.TreeUtil;
import java.lang.reflect.InvocationTargetException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RemoteGroupNode
extends NavigationItemNode {
    public RemoteGroupNode(RemoteNavigationItem item) {
        this(item, null);
    }

    public RemoteGroupNode(RemoteNavigationItem item, String actionPath) {
        super((NavigationItem)item);
        if (actionPath != null) {
            this.setActionPath(actionPath);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set groupSet = Sheet.createPropertiesSet();
        groupSet.setName("group");
        groupSet.setDisplayName(NbBundle.getMessage(RemoteGroupNode.class, (String)"RemoteGroupNode.set.group"));
        NavigationItem item = (NavigationItem)this.getLookup().lookup(NavigationItem.class);
        int unitCount = TreeUtil.countUnitsInTree(item);
        String displayName = NbBundle.getMessage(RemoteGroupNode.class, (String)"RemoteGroupNode.attribute.units");
        ReadOnlyImpl property = new ReadOnlyImpl("units", displayName, unitCount);
        groupSet.put((Node.Property)property);
        int groupCount = TreeUtil.countGroupsInTree(item);
        displayName = NbBundle.getMessage(RemoteGroupNode.class, (String)"RemoteGroupNode.attribute.groups");
        property = new ReadOnlyImpl("groups", displayName, groupCount);
        groupSet.put((Node.Property)property);
        sheet.put(groupSet);
        return sheet;
    }

    private class ReadOnlyImpl
    extends PropertySupport.ReadOnly<Integer> {
        private int value;

        public ReadOnlyImpl(String name, String displayName, int value) {
            super(name, Integer.class, displayName, "");
            this.value = value;
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }
    }
}

