/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.idm.core.gui.navigation.NavigationTopComponent;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.navigation.OperatorGroupNavigationItem;
import de.proveo.idm.remote.server.navigation.OperatorNavigationItem;
import de.proveo.idm.remote.server.util.TreeUtil;
import de.proveo.util.useuser.UseUserTreeNodeBean;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.WindowManager;

public class OperatorGroupNode
extends NavigationItemNode {
    private static final Logger log = Logger.getLogger(OperatorGroupNode.class.getName());

    public OperatorGroupNode(OperatorGroupNavigationItem item) {
        this(item, null);
    }

    public OperatorGroupNode(OperatorGroupNavigationItem item, String actionPath) {
        super((NavigationItem)item);
        if (actionPath != null) {
            this.setActionPath(actionPath);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Node.Cookie getCookie(Class clazz) {
        Children ch = this.getChildren();
        if (clazz.isInstance(ch)) {
            return (Node.Cookie)ch;
        }
        return super.getCookie(clazz);
    }

    public PasteType getDropType(final Transferable t, final int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (null != dropNode) {
            final OperatorNavigationItem useUserItem = (OperatorNavigationItem)((Object)dropNode.getLookup().lookup(OperatorNavigationItem.class));
            if (!this.equals(dropNode.getParentNode()) && useUserItem != null) {
                final long useUserId = useUserItem.getData().getId();
                UseUserTreeNodeBean useGroup = ((OperatorGroupNavigationItem)this.navigationItem).getData();
                final EFMServerNavigationItem serverItem = this.getServerNavigationItem(this.navigationItem);
                if (serverItem != null && ObjectUtils.equals((Object)serverItem, (Object)this.getServerNavigationItem((NavigationItem)useUserItem)) && !this.isChild(useUserId, useGroup)) {
                    final EFMServer server = serverItem.getServerInstance();
                    return new PasteType(){

                        public Transferable paste() throws IOException {
                            if ((action & 2) != 0) {
                                long currentGroupId;
                                long tmpCurrentGroupId = -1L;
                                NavigationItem remItem = useUserItem.getParent();
                                if (remItem != null && remItem instanceof OperatorGroupNavigationItem) {
                                    tmpCurrentGroupId = ((OperatorGroupNavigationItem)remItem).getData().getId();
                                }
                                if ((currentGroupId = tmpCurrentGroupId) == -1L) {
                                    OperatorGroupNode.this.moveUseUserIntoGroup(server, serverItem, useUserId, -1L);
                                } else {
                                    JPopupMenu menu = new JPopupMenu();
                                    JMenuItem move = new JMenuItem(NbBundle.getMessage(OperatorGroupNode.class, (String)"OperatorGroupNode.attribute.move"));
                                    move.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            OperatorGroupNode.this.moveUseUserIntoGroup(server, serverItem, useUserId, currentGroupId);
                                        }
                                    });
                                    JMenuItem copy = new JMenuItem(NbBundle.getMessage(OperatorGroupNode.class, (String)"OperatorGroupNode.attribute.copy"));
                                    copy.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            OperatorGroupNode.this.moveUseUserIntoGroup(server, serverItem, useUserId, -1L);
                                        }
                                    });
                                    menu.add(move);
                                    menu.add(copy);
                                    Object comp = NavigationTopComponent.getDefault();
                                    Point mp = ((Component)comp).getMousePosition();
                                    if (mp == null) {
                                        comp = WindowManager.getDefault().getMainWindow();
                                        mp = ((Component)comp).getMousePosition();
                                    }
                                    menu.show((Component)comp, mp.x, mp.y);
                                }
                            }
                            return t;
                        }
                    };
                }
            }
        }
        return null;
    }

    private void moveUseUserIntoGroup(EFMServer server, EFMServerNavigationItem serverItem, long useUserId, long currentGroupId) {
        try {
            if (currentGroupId != -1L) {
                server.getRemoteOperatorAdapter().removeOperatorFromGroup(useUserId, currentGroupId);
            }
            server.getRemoteOperatorAdapter().insertOperatorIntoGroup(useUserId, ((OperatorGroupNavigationItem)this.navigationItem).getData().getId());
            TreeUtil.refreshTreeForServerItem(serverItem);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Moving useUser into other group runs into", ex);
        }
    }

    private boolean isChild(long useUserId, UseUserTreeNodeBean useGroup) {
        List children = useGroup.getChildren();
        if (children != null && !children.isEmpty()) {
            for (UseUserTreeNodeBean c : children) {
                if (useUserId != c.getId()) continue;
                return true;
            }
        }
        return false;
    }

    private EFMServerNavigationItem getServerNavigationItem(NavigationItem item) {
        EFMServerNavigationItem serverItem = null;
        while (item != null && !(item instanceof EFMServerNavigationItem)) {
            item = item.getParent();
        }
        if (item != null && item instanceof EFMServerNavigationItem) {
            serverItem = (EFMServerNavigationItem)item;
        }
        return serverItem;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set groupSet = Sheet.createPropertiesSet();
        groupSet.setName("operatorGroup");
        groupSet.setDisplayName(NbBundle.getMessage(OperatorGroupNode.class, (String)"OperatorGroupNode.set.operatorGroup"));
        OperatorGroupNavigationItem item = (OperatorGroupNavigationItem)((Object)this.getLookup().lookup(OperatorGroupNavigationItem.class));
        UseUserTreeNodeBean useGroup = item.getData();
        String displayName = NbBundle.getMessage(OperatorGroupNode.class, (String)"OperatorGroupNode.attribute.name");
        ReadOnlyImpl<String> property = new ReadOnlyImpl<String>("name", displayName, useGroup.getName(), String.class);
        groupSet.put(property);
        displayName = NbBundle.getMessage(OperatorGroupNode.class, (String)"OperatorGroupNode.attribute.desc");
        property = new ReadOnlyImpl<String>("desc", displayName, useGroup.getDesc(), String.class);
        groupSet.put(property);
        int unitCount = TreeUtil.countUnitsInTree((NavigationItem)item);
        String displayName2 = NbBundle.getMessage(OperatorGroupNode.class, (String)"OperatorGroupNode.attribute.operators");
        ReadOnlyImpl<Integer> property2 = new ReadOnlyImpl<Integer>("operators", displayName2, unitCount, Integer.class);
        groupSet.put(property2);
        sheet.put(groupSet);
        return sheet;
    }

    private class ReadOnlyImpl<T>
    extends PropertySupport.ReadOnly<T> {
        private final T value;

        public ReadOnlyImpl(String name, String displayName, T value, Class<T> type) {
            super(name, type, displayName, "");
            this.value = value;
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }
    }
}

