/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation.nodes;

import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.core.gui.navigation.api.EFMServerNodeSheetProvider;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationManager;
import de.proveo.idm.core.gui.navigation.api.impl.NavigationItemNode;
import de.proveo.idm.remote.server.api.EFMServerManager;
import de.proveo.idm.remote.server.editors.VersionPropertyEditor;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.ssh.service.gui.TunnelEditor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.ProxyLookup;

public class EFMServerNode
extends NavigationItemNode {
    private static final Logger log = Logger.getLogger(EFMServerNode.class.getName());

    public EFMServerNode(EFMServerNavigationItem server) {
        super((NavigationItem)server);
        this.setActionPath("Actions/Remote/Server/Child");
        server.getServerData().addPropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    public boolean canRename() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    public Action getPreferredAction() {
        Action a;
        Action action = super.getPreferredAction();
        Action[] actions = this.getActions(false);
        if (this.getChildren().getNodesCount() == 0 && actions != null && actions.length > 0 && (a = actions[0]) != null) {
            if (a instanceof ContextAwareAction) {
                a = ((ContextAwareAction)a).createContextAwareInstance(super.getLookup());
            }
            if (a.isEnabled() && !(a instanceof Presenter)) {
                action = a;
            }
        }
        return action;
    }

    public void setName(String s) {
        EFMServerData data;
        if (s == null) {
            s = "";
        }
        if (!s.equals((data = ((EFMServerNavigationItem)this.navigationItem).getServerData()).getServername())) {
            data.setServername(s);
        }
        super.setName(s);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        try {
            EFMServerNavigationItem serverItem = (EFMServerNavigationItem)this.getLookup().lookup(EFMServerNavigationItem.class);
            EFMServerData data = serverItem.getServerData();
            Sheet.Set dataSheet = Sheet.createPropertiesSet();
            dataSheet.setName("server_data");
            dataSheet.setDisplayName(NbBundle.getMessage(EFMServerNode.class, (String)"EFMServerNode.set.serverdata"));
            sheet.put(dataSheet);
            PropertySupport.Reflection nameProp = new PropertySupport.Reflection((Object)data, String.class, "getServername", "setServername");
            nameProp.setDisplayName(NbBundle.getMessage(EFMServerNode.class, (String)"EFMServerNode.attribute.name"));
            nameProp.setName("servername");
            dataSheet.put((Node.Property)nameProp);
            PropertySupport.Reflection urlProp = new PropertySupport.Reflection((Object)data, String.class, "getUrl", "setUrl");
            urlProp.setDisplayName(NbBundle.getMessage(EFMServerNode.class, (String)"EFMServerNode.attribute.url"));
            urlProp.setName("url");
            dataSheet.put((Node.Property)urlProp);
            EFMServerManager sMgr = (EFMServerManager)Lookup.getDefault().lookup(EFMServerManager.class);
            final List<String> versions = sMgr.getSupportedVersions();
            if (versions.size() > 1) {
                PropertySupport.Reflection versionProp = new PropertySupport.Reflection((Object)data, String.class, "getVersion", "setVersion");
                versionProp.setDisplayName(NbBundle.getMessage(EFMServerNode.class, (String)"EFMServerNode.attribute.version"));
                versionProp.setName("version");
                versionProp.setPropertyEditorClass(VersionPropertyEditor.class);
                dataSheet.put((Node.Property)versionProp);
            } else {
                String displayName = NbBundle.getMessage(EFMServerNode.class, (String)"EFMServerNode.attribute.version");
                PropertySupport.ReadOnly<String> versionProp = new PropertySupport.ReadOnly<String>("version", String.class, displayName, ""){

                    public String getValue() throws IllegalAccessException, InvocationTargetException {
                        return (String)versions.get(0);
                    }
                };
                dataSheet.put((Node.Property)versionProp);
            }
            PropertySupport.Reflection tunnelProp = new PropertySupport.Reflection((Object)data, Collection.class, "getTunnel", "setTunnel");
            tunnelProp.setName("tunnel");
            tunnelProp.setDisplayName(NbBundle.getMessage(EFMServerNode.class, (String)"EFMServerNode.attribute.tunnel"));
            tunnelProp.setPropertyEditorClass(TunnelEditor.class);
            dataSheet.put((Node.Property)tunnelProp);
            tunnelProp = new PropertySupport.Reflection((Object)data, Collection.class, "getInfomanTunnel", "setInfomanTunnel");
            tunnelProp.setName("infomanTunnel");
            tunnelProp.setDisplayName(NbBundle.getMessage(EFMServerNode.class, (String)"EFMServerNode.attribute.tunnel.infoman"));
            tunnelProp.setPropertyEditorClass(TunnelEditor.class);
            dataSheet.put((Node.Property)tunnelProp);
            try {
                ProxyLookup lookup = new ProxyLookup(new Lookup[]{Lookup.getDefault(), this.getLookup()});
                Collection sheetProviders = lookup.lookupAll(EFMServerNodeSheetProvider.class);
                if (sheetProviders != null) {
                    for (EFMServerNodeSheetProvider sheetProvider : sheetProviders) {
                        sheet.put(sheetProvider.getExtraSheet(data));
                    }
                }
            }
            catch (Exception ex) {
                log.log(Level.INFO, "Loading extra server sheets runs into", ex);
            }
        }
        catch (NoSuchMethodException ex) {
            log.log(Level.INFO, "Creating server sheet runs into", ex);
        }
        return sheet;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("EFMServerData.name")) {
            NavigationItem item = (NavigationItem)this.getLookup().lookup(NavigationItem.class);
            item.setName((String)evt.getNewValue());
            RemoteNavigationManager mgr = (RemoteNavigationManager)Lookup.getDefault().lookup(RemoteNavigationManager.class);
            mgr.store();
        }
    }
}

