/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.navigation;

import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.impl.AbstractNavigationItem;
import de.proveo.idm.remote.server.navigation.DatasyncResourceNavigationItem;
import de.proveo.idm.remote.server.util.TreeUtil;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openide.util.NbBundle;

public class DatasyncTaskNavigationItem
extends AbstractNavigationItem {
    private final DatasyncTaskValue task;

    public DatasyncTaskNavigationItem(DatasyncTaskValue task) {
        this(task, null);
    }

    public DatasyncTaskNavigationItem(DatasyncTaskValue task, NavigationItem parent) {
        super(DatasyncTaskNavigationItem.createTaskName(task), parent);
        this.task = task;
        List resources = task.getResources();
        if (resources != null && !resources.isEmpty()) {
            for (DatasyncResourceValue resource : resources) {
                DatasyncResourceNavigationItem resItem = new DatasyncResourceNavigationItem(resource, (NavigationItem)this);
                if (TreeUtil.isConfigurationResourceItem(resItem)) {
                    resItem.setActionPath("Actions/Remote/Server/Resources/Config");
                }
                this.addChild((NavigationItem)resItem);
            }
        }
    }

    public DatasyncTaskValue getDatasyncTask() {
        return this.task;
    }

    private static String createTaskName(DatasyncTaskValue task) {
        return NbBundle.getMessage(DatasyncResourceNavigationItem.class, (String)"DatasyncTaskNavigationItem.name", (Object)task.getTaskId());
    }

    public String getIconBaseWithExtension() {
        return "de/proveo/idm/remote/server/resources/task.png";
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatasyncTaskNavigationItem) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof DatasyncTaskNavigationItem) {
                DatasyncTaskNavigationItem other = (DatasyncTaskNavigationItem)((Object)obj);
                DatasyncTaskValue otherTask = other.getDatasyncTask();
                if (this.task == null && otherTask == null) {
                    return true;
                }
                if (this.task == null || otherTask == null) {
                    return false;
                }
                return this.task.getTaskId() == otherTask.getTaskId();
            }
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.task == null ? -1L : this.task.getTaskId());
        hcb.append((Object)(this.task == null ? "" : this.task.getTaskInfo()));
        hcb.append(this.task == null ? -1L : this.task.getClientId());
        hcb.append((Object)(this.task == null ? "" : this.task.getClientSerialNumber()));
        return hcb.toHashCode();
    }
}

