/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.impl;

import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.remote.server.api.EFMServerManager;
import de.proveo.idm.remote.server.api.impl.HttpClient4Factory;
import de.proveo.idm.ssh.service.SSHConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ServerFinder {
    private static final String VERSION_SERVICE_SUFFIX = "/admin/application/version";
    private static final Logger log = Logger.getLogger(ServerFinder.class.getName());
    private EFMServerData data;
    private Credentials credentials;

    public ServerFinder(EFMServerData data, Credentials credentials) {
        this.data = data;
        this.credentials = credentials;
    }

    public String findVersion(String urlStr) throws Exception {
        SSHConnection connection = null;
        try {
            Collection tunnel;
            URL url = new URL(urlStr);
            int port = url.getPort();
            if (port == -1) {
                String protocol = url.getProtocol();
                url = protocol.equals("http") ? new URL(protocol, url.getHost(), 8080, url.getFile()) : new URL(protocol, url.getHost(), 443, url.getFile());
            }
            if ((tunnel = this.data.getTunnel()) != null && !tunnel.isEmpty()) {
                connection = new SSHConnection();
                connection.addTunnel(tunnel);
                connection.establishTunnel(url.toString());
                int connectionPort = connection.getConnectionPort();
                url = new URL(url.getProtocol(), "localhost", connectionPort, url.getFile());
            }
            HttpClient client = HttpClient4Factory.createHttpsClient(url, this.credentials);
            HttpHost targetHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
            HttpGet httpget = new HttpGet(VERSION_SERVICE_SUFFIX);
            HttpResponse httpResponse = client.execute(targetHost, (HttpRequest)httpget);
            HttpEntity entity = httpResponse.getEntity();
            String version = null;
            int status = httpResponse.getStatusLine().getStatusCode();
            switch (status) {
                case 200: {
                    byte[] response = IOUtils.toByteArray((InputStream)entity.getContent());
                    if (response != null) {
                        version = new String(response);
                    }
                    if (!log.isLoggable(Level.INFO)) break;
                    log.log(Level.INFO, "Found server version {0}", version);
                    break;
                }
                case 401: {
                    this.notifyUser("ServerFinder.error.401");
                    break;
                }
                case 404: {
                    version = this.askForVersion(NbBundle.getMessage(ServerFinder.class, (String)"ServerFinder.finderDialog.message"));
                    break;
                }
                case 403: {
                    this.notifyUser("ServerFinder.error.403");
                    break;
                }
                default: {
                    throw new Exception("Unhandled HTTP error. (Code: " + status + ")");
                }
            }
            EntityUtils.consume((HttpEntity)entity);
            String string = version;
            return string;
        }
        catch (Exception ex) {
            if (connection != null) {
                connection.disconnect();
            }
            throw ex;
        }
    }

    public String askForVersion(String msg) {
        String title;
        EFMServerManager mgr = (EFMServerManager)Lookup.getDefault().lookup(EFMServerManager.class);
        VersionPanel panel = new VersionPanel(msg, mgr.getSupportedVersions(false));
        Object option = DialogUtil.showOkCancelQuestionDialog((Object)panel, (String)(title = NbBundle.getMessage(ServerFinder.class, (String)"ServerFinder.dialog.title")));
        if (DialogUtil.OK_OPTION.equals(option)) {
            return panel.getSelectedVersion();
        }
        return null;
    }

    private GetMethod createHttpGetStatement(String url) {
        GetMethod get = new GetMethod(url + VERSION_SERVICE_SUFFIX);
        get.addRequestHeader("ContentType", "text/plain");
        get.addRequestHeader("Accept", "text/plain");
        return get;
    }

    private void notifyUser(String msgKey) {
        String msg = NbBundle.getMessage(ServerFinder.class, (String)msgKey);
        DialogUtil.showErrorDialog((Object)msg);
    }

    private class VersionPanel
    extends JPanel {
        private ArrayList<JRadioButton> buttons = new ArrayList();

        public VersionPanel(String msg, List<String> versions) {
            ButtonGroup group = new ButtonGroup();
            this.setLayout(new BorderLayout());
            JLabel label = new JLabel(msg);
            JPanel versionsPnl = new JPanel();
            for (String version : versions) {
                JRadioButton button = new JRadioButton(version);
                group.add(button);
                versionsPnl.add(button);
                this.buttons.add(button);
            }
            this.add((Component)label, "North");
            this.add((Component)versionsPnl, "Center");
        }

        public String getSelectedVersion() {
            for (JRadioButton button : this.buttons) {
                if (!button.isSelected()) continue;
                return button.getText();
            }
            return null;
        }
    }
}

