/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.gui;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.remote.server.util.ExtendedValue;
import de.proveo.idm.remote.server.util.telit.TelitFile;
import de.proveo.idm.software.archive.api.Resource;
import de.proveo.idm.software.archive.api.gui.ResourceSelectorDialog;
import de.proveo.idm.software.archive.util.ChecksumUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.combobox.ListComboBoxModel;
import org.openide.DialogDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TimeResourceSelectorPanel
extends JPanel
implements DocumentListener,
HelpCtx.Provider {
    private static final Logger log = Logger.getLogger(TimeResourceSelectorPanel.class.getName());
    private static final int HOUR_MULTIPLIER = 3600000;
    private static final int MINUTES_MULTIPLIER = 60000;
    private String noResourceItemName = null;
    private String uploadNewResourceItemName = null;
    private final DefaultComboBoxModel resourceCBModel = new DefaultComboBoxModel();
    private Resource.ResourceType[] acceptedTypes = new Resource.ResourceType[0];
    private boolean resourceSelectionOptional = false;
    private long time;
    private JXDatePicker datePicker = null;
    private Device.DeviceType deviceType;
    private String resourceType;
    private JPanel datePnl;
    private JLabel errorLbl;
    private JPanel jPanel1;
    private JComboBox resourceCB;
    private JLabel resourceLbl;
    private JPanel resourcePnl;
    private JLabel timeLbl;
    private JPanel timePnl;
    private JTextField timeTF;
    private JLabel timeZoneLbl;
    private JComboBox timeZonesCmbBox;

    public TimeResourceSelectorPanel(Device.DeviceType deviceType, String resourceType, long time, String serverTimeZoneId) {
        this.deviceType = deviceType;
        this.resourceType = resourceType;
        this.noResourceItemName = NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.noResource", (Object)this.resourceType);
        this.uploadNewResourceItemName = NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.uploadNewResource", (Object)this.resourceType);
        TimeZone serverTimeZone = TimeZone.getTimeZone(serverTimeZoneId);
        this.time = time;
        if (this.time <= 0L) {
            this.time = System.currentTimeMillis();
        }
        Date today = new Date(this.time);
        this.datePicker = new JXDatePicker(today);
        this.datePicker.setTimeZone(serverTimeZone);
        this.datePicker.setDate(today);
        this.datePicker.getMonthView().setSelectionDate(today);
        this.initComponents();
        this.setResourceSelectionOptional(false);
        this.timeZonesCmbBox.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TimeResourceSelectorPanel.this.timeZonesCmbBoxFocusLost(e);
            }
        });
        ArrayList<ExtendedValue> timeZoneList = new ArrayList<ExtendedValue>();
        TimeZone clientTimeZone = TimeZone.getDefault();
        timeZoneList.add(new ExtendedValue(serverTimeZone, serverTimeZone.getDisplayName() + " (" + NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.serverTimeZone.label") + ")"));
        if (clientTimeZone.equals(serverTimeZone)) {
            timeZoneList.clear();
        }
        timeZoneList.add(new ExtendedValue(clientTimeZone, clientTimeZone.getDisplayName() + " (" + NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.localTimeZone.label") + ")"));
        String[] timeZoneIds = TimeZone.getAvailableIDs();
        TreeMap<String, TimeZone> sortedTimeZones = new TreeMap<String, TimeZone>();
        for (String tzId : timeZoneIds) {
            TimeZone tz = TimeZone.getTimeZone(tzId);
            String tzName = tzId;
            if (tzName.startsWith("Etc/")) {
                tzName = tz.getDisplayName();
            }
            sortedTimeZones.put(tzName, tz);
        }
        for (String tzName : sortedTimeZones.keySet()) {
            TimeZone tz = (TimeZone)sortedTimeZones.get(tzName);
            timeZoneList.add(new ExtendedValue(tz, tzName));
        }
        this.timeZonesCmbBox.setModel(new ListComboBoxModel(timeZoneList));
        AutoCompleteDecorator.decorate((JComboBox)this.timeZonesCmbBox);
        this.errorLbl.setText("");
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setTimeZone(serverTimeZone);
        this.timeTF.setText(sdf.format(today));
        this.timeTF.getDocument().addDocumentListener(this);
        this.time = this.parseTime();
    }

    public void setResourceSelectionOptional(boolean optional) {
        this.resourceSelectionOptional = optional;
        if (this.resourceSelectionOptional) {
            this.resourceLbl.setText(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.resourceLbl.optional.text", (Object)this.resourceType));
        } else {
            this.resourceLbl.setText(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.resourceLbl.text", (Object)this.resourceType));
        }
    }

    public boolean isResourceSelectionOptional() {
        return this.resourceSelectionOptional;
    }

    public void setResourceSelectionEnabled(boolean enabled) {
        this.resourceLbl.setVisible(enabled);
        this.resourceCB.setVisible(enabled);
    }

    public HelpCtx getHelpCtx() {
        if ("Telit Modem Firmware".equals(this.resourceType)) {
            return new HelpCtx("de.proveo.idm.remote.server.telitModemFirmwareUpdate");
        }
        return new HelpCtx("de.proveo.idm.remote.server.softwareUpdate");
    }

    public Date getSelectedDate() {
        return this.datePicker.getMonthView().getSelectionDate();
    }

    public long getScheduledUpdateTime() {
        return this.datePicker.getMonthView().getSelectionDate().getTime() + this.time;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void addResources(Collection<DatasyncResourceValue> resources) {
        boolean additionalResourceUpdatesEnabled = this.isAdditionalResourceUploadEnabled();
        this.resourceCBModel.removeAllElements();
        this.resourceCBModel.addElement(this.noResourceItemName);
        for (DatasyncResourceValue resource : resources) {
            this.resourceCBModel.addElement(resource);
        }
        if (additionalResourceUpdatesEnabled) {
            this.setAdditionalResourceUploadEnabled(true);
        }
    }

    public void setAdditionalResourceUploadEnabled(boolean enabled) {
        if (enabled) {
            if (this.resourceCBModel.getIndexOf(this.uploadNewResourceItemName) == -1) {
                if (this.resourceCBModel.getSize() == 0) {
                    this.resourceCBModel.addElement(this.noResourceItemName);
                }
                this.resourceCBModel.addElement(this.uploadNewResourceItemName);
            }
        } else {
            this.resourceCBModel.removeElement(this.uploadNewResourceItemName);
        }
    }

    public boolean isAdditionalResourceUploadEnabled() {
        return this.resourceCBModel.getIndexOf(this.uploadNewResourceItemName) != -1;
    }

    public void setAcceptedResourceTypes(Resource.ResourceType ... acceptedTypes) {
        this.acceptedTypes = acceptedTypes;
    }

    public DatasyncResourceValue getSelectedResource() {
        DatasyncResourceValue ret = null;
        Object selected = this.resourceCB.getSelectedItem();
        if (selected instanceof DatasyncResourceValue) {
            ret = (DatasyncResourceValue)selected;
        }
        return ret;
    }

    public void setSelectedResource(DatasyncResourceValue value) {
        int select = -1;
        for (int i = 0; i < this.resourceCBModel.getSize(); ++i) {
            DatasyncResourceValue v;
            Object obj = this.resourceCBModel.getElementAt(i);
            if (!(obj instanceof DatasyncResourceValue) || !ObjectUtils.equals((Object)(v = (DatasyncResourceValue)obj).getResourceName(), (Object)value.getResourceName()) || v.getResourceId() != value.getResourceId() || !ObjectUtils.equals((Object)v.getChecksum(), (Object)value.getChecksum())) continue;
            select = i;
            break;
        }
        if (select != -1) {
            this.resourceCB.setSelectedIndex(select);
        }
    }

    private long parseTime() throws IllegalArgumentException, NumberFormatException {
        String timeStr = this.timeTF.getText();
        long parseTime = 0L;
        if (!timeStr.isEmpty()) {
            String[] tokens = timeStr.split(":");
            block5: for (int i = 0; i < tokens.length; ++i) {
                switch (i) {
                    case 0: {
                        long hours = Long.parseLong(tokens[i]) * 3600000L;
                        if (hours > 82800000L) {
                            throw new IllegalArgumentException("Exceeded maximum value for hours (23)");
                        }
                        parseTime += hours;
                        continue block5;
                    }
                    case 1: {
                        long minutes = Long.parseLong(tokens[i]) * 60000L;
                        if (minutes > 3540000L) {
                            throw new IllegalArgumentException("Exceeded maximum value for minutes (59)");
                        }
                        parseTime += minutes;
                        continue block5;
                    }
                    case 2: {
                        long seconds = Long.parseLong(tokens[i]) * 1000L;
                        if (seconds > 59000L) {
                            throw new IllegalArgumentException("Exceeded maximum value for seconds (59)");
                        }
                        parseTime += seconds;
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong format " + timeStr + " must be HH:mm:ss");
                    }
                }
            }
        } else {
            this.errorLbl.setText("");
        }
        return parseTime;
    }

    private void initComponents() {
        this.timePnl = new JPanel();
        this.timeLbl = new JLabel();
        this.timeTF = new JTextField();
        this.errorLbl = new JLabel();
        this.datePnl = new JPanel();
        this.jPanel1 = new JPanel();
        this.timeZonesCmbBox = new JComboBox();
        this.timeZoneLbl = new JLabel();
        this.resourcePnl = new JPanel();
        this.resourceLbl = new JLabel();
        this.resourceCB = new JComboBox();
        this.setLayout(new BoxLayout(this, 3));
        this.timePnl.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.timePnl.border.title")));
        this.timeLbl.setText(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.timeLbl.text"));
        this.timeTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeResourceSelectorPanel.this.timeTFActionPerformed(evt);
            }
        });
        this.errorLbl.setForeground(new Color(255, 0, 0));
        this.errorLbl.setText("Error text");
        this.datePnl.setMinimumSize(new Dimension(20, 20));
        this.datePnl.setLayout(new BorderLayout());
        this.timeZonesCmbBox.setEditable(true);
        this.timeZonesCmbBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TimeResourceSelectorPanel.this.timeZonesCmbBoxItemStateChanged(evt);
            }
        });
        this.timeZonesCmbBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimeResourceSelectorPanel.this.timeZonesCmbBoxActionPerformed(evt);
            }
        });
        this.timeZonesCmbBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TimeResourceSelectorPanel.this.timeZonesCmbBoxFocusLost(evt);
            }
        });
        this.timeZoneLbl.setText(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.timeZoneLbl.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.timeZoneLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.timeZonesCmbBox, 0, 573, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeZoneLbl, -2, 24, -2).addComponent(this.timeZonesCmbBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.datePnl.add((Component)this.jPanel1, "Last");
        this.datePnl.add((Component)this.datePicker.getMonthView(), "Center");
        GroupLayout timePnlLayout = new GroupLayout(this.timePnl);
        this.timePnl.setLayout(timePnlLayout);
        timePnlLayout.setHorizontalGroup(timePnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, timePnlLayout.createSequentialGroup().addContainerGap().addGroup(timePnlLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.datePnl, GroupLayout.Alignment.LEADING, -1, 632, Short.MAX_VALUE).addComponent(this.errorLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, timePnlLayout.createSequentialGroup().addComponent(this.timeLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.timeTF, -2, 101, -2).addGap(308, 308, 308))).addContainerGap()));
        timePnlLayout.setVerticalGroup(timePnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(timePnlLayout.createSequentialGroup().addContainerGap().addGroup(timePnlLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeLbl).addComponent(this.timeTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datePnl, -1, 197, Short.MAX_VALUE).addContainerGap()));
        this.add(this.timePnl);
        this.resourceLbl.setText(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.resourceLbl.text"));
        this.resourceCB.setModel(this.resourceCBModel);
        this.resourceCB.setRenderer(new ResourceRenderer());
        this.resourceCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TimeResourceSelectorPanel.this.resourceCBItemStateChanged(evt);
            }
        });
        GroupLayout resourcePnlLayout = new GroupLayout(this.resourcePnl);
        this.resourcePnl.setLayout(resourcePnlLayout);
        resourcePnlLayout.setHorizontalGroup(resourcePnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(resourcePnlLayout.createSequentialGroup().addContainerGap(238, Short.MAX_VALUE).addComponent(this.resourceLbl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.resourceCB, -2, 386, -2).addContainerGap()));
        resourcePnlLayout.setVerticalGroup(resourcePnlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(resourcePnlLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(resourcePnlLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resourceCB, -2, -1, -2).addComponent(this.resourceLbl)).addContainerGap(16, Short.MAX_VALUE)));
        this.add(this.resourcePnl);
    }

    private void timeZoneChanged(boolean commit) {
        Object value = null;
        Object selectedItem = this.timeZonesCmbBox.getSelectedItem();
        if (selectedItem != null && selectedItem instanceof ExtendedValue) {
            value = ((ExtendedValue)selectedItem).getValue();
        } else {
            selectedItem = this.timeZonesCmbBox.getItemAt(0);
            if (selectedItem != null && selectedItem instanceof ExtendedValue) {
                value = ((ExtendedValue)selectedItem).getValue();
            }
        }
        if (value != null && value instanceof TimeZone) {
            Date date = this.datePicker.getMonthView().getSelectionDate();
            this.datePicker.setTimeZone((TimeZone)value);
            this.datePicker.setDate(date);
            this.datePicker.getMonthView().setSelectionDate(date);
            if (commit) {
                this.timeZonesCmbBox.setSelectedItem(selectedItem);
                this.timeZonesCmbBox.getModel().setSelectedItem(selectedItem);
                this.timeZonesCmbBox.getEditor().setItem(selectedItem);
            }
        }
    }

    private void timeZonesCmbBoxItemStateChanged(ItemEvent evt) {
        this.timeZoneChanged(false);
    }

    private void timeZonesCmbBoxActionPerformed(ActionEvent evt) {
        this.timeZoneChanged(true);
    }

    private void timeZonesCmbBoxFocusLost(FocusEvent evt) {
        this.timeZoneChanged(true);
    }

    private void resourceCBItemStateChanged(ItemEvent evt) {
        block24: {
            if (1 != evt.getStateChange()) {
                return;
            }
            Object selected = evt.getItem();
            if (selected != null && !(selected instanceof DatasyncResourceValue) && selected.toString().equals(this.uploadNewResourceItemName)) {
                Device.DeviceType devType = Device.DeviceType.ANY;
                if (this.deviceType.equals((Object)Device.DeviceType.INFOMAN)) {
                    devType = Device.DeviceType.INFOMAN;
                } else if (this.deviceType.equals((Object)Device.DeviceType.INFOMAN_EFM)) {
                    devType = Device.DeviceType.INFOMAN_EFM;
                }
                File file = null;
                ResourceSelectorDialog rsd = new ResourceSelectorDialog(devType, this.acceptedTypes);
                Resource res = rsd.selectResource(null);
                if (res != null) {
                    file = res.getAsFile();
                }
                if (file != null) {
                    try {
                        String checksum;
                        File checksumFile;
                        String filename;
                        String resName;
                        TelitFile telitFile;
                        block23: {
                            telitFile = null;
                            resName = res.getName();
                            filename = file.getName();
                            if (ArrayUtils.contains((Object[])this.acceptedTypes, (Object)Resource.ResourceType.MODEM_FIRMWARE)) {
                                try {
                                    telitFile = TelitFile.create(file);
                                    log.log(Level.INFO, "Selected telit modem firmware for upload: {0} {1} ({2})", new Object[]{telitFile.getpName(), telitFile.getDisplaySwVersion(), telitFile.getSwVer()});
                                }
                                catch (Exception ex) {
                                    if (this.acceptedTypes.length != 1 || !this.acceptedTypes[0].equals((Object)Resource.ResourceType.MODEM_FIRMWARE)) break block23;
                                    log.log(Level.WARNING, "Parse telit modem firmware update file runs into", ex);
                                    DialogUtil.showErrorDialog((Object)NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.resource.invalidModemFirmware.msg"), (String)NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.resource.invalidModemFirmware.title"));
                                    throw ex;
                                }
                            }
                        }
                        if (!(checksumFile = new File(file.getAbsolutePath() + ".sha")).exists()) {
                            checksumFile = new File(file.getAbsolutePath() + ".SHA");
                        }
                        if (checksumFile.exists()) {
                            try {
                                String checksumFileContent = FileUtils.readFileToString((File)checksumFile);
                                checksum = StringUtils.split((String)checksumFileContent)[0].trim();
                            }
                            catch (Exception ex) {
                                checksum = ChecksumUtil.generateSHA1Checksum((File)file);
                            }
                        } else {
                            checksum = ChecksumUtil.generateSHA1Checksum((File)file);
                        }
                        DialogUtil.InputLine il = new DialogUtil.InputLine(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.resourceNameDialog.msg"), NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.resourceNameDialog.title"), 2, 3);
                        il.setInputText(resName);
                        Object ret = DialogUtil.showDialogDescriptor((DialogDescriptor)il);
                        if (!DialogUtil.OK_OPTION.equals(ret)) {
                            this.resourceCB.setSelectedItem(this.noResourceItemName);
                            return;
                        }
                        String resourceName = il.getInputText();
                        String resType = StringUtils.remove((String)this.resourceType, (String)" ");
                        String deviceResourceType = Device.DeviceType.INFOMAN.toString() + resType;
                        if (this.deviceType != null) {
                            deviceResourceType = this.deviceType.toString() + resType;
                        }
                        DatasyncResourceValue value = new DatasyncResourceValue();
                        value.setResourceId(0L);
                        value.setResource(IOUtils.toByteArray((InputStream)res.getAsStream()));
                        value.setChecksum(checksum);
                        value.setResourceName(resourceName);
                        value.setValidFrom(System.currentTimeMillis());
                        DatasyncMetainfoValue descriptionMeta = new DatasyncMetainfoValue();
                        descriptionMeta.setKey(MetaInfoKey.DESCRIPTION.toString());
                        descriptionMeta.setValue(resourceName);
                        value.addMetaInfoValue(descriptionMeta);
                        DatasyncMetainfoValue checksumMeta = new DatasyncMetainfoValue();
                        checksumMeta.setKey(MetaInfoKey.CHECKSUM.toString());
                        checksumMeta.setValue(checksum);
                        value.addMetaInfoValue(checksumMeta);
                        DatasyncMetainfoValue checksumTypeMeta = new DatasyncMetainfoValue();
                        checksumTypeMeta.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
                        checksumTypeMeta.setValue("SHA1");
                        value.addMetaInfoValue(checksumTypeMeta);
                        DatasyncMetainfoValue contentTypeMeta = new DatasyncMetainfoValue();
                        contentTypeMeta.setKey(MetaInfoKey.CONTENT_TYPE.toString());
                        contentTypeMeta.setValue("application/octet-stream");
                        value.addMetaInfoValue(contentTypeMeta);
                        DatasyncMetainfoValue fileNameMeta = new DatasyncMetainfoValue();
                        fileNameMeta.setKey(MetaInfoKey.FILE_NAME.toString());
                        fileNameMeta.setValue(filename);
                        value.addMetaInfoValue(fileNameMeta);
                        DatasyncMetainfoValue resourceTypeMeta = new DatasyncMetainfoValue();
                        resourceTypeMeta.setKey(MetaInfoKey.RESOURCE_TYPE.toString());
                        resourceTypeMeta.setValue(deviceResourceType);
                        value.addMetaInfoValue(resourceTypeMeta);
                        if ((this.deviceType == null || this.deviceType.equals((Object)Device.DeviceType.INFOMAN)) && this.resourceType != null && this.resourceType.equals("Software")) {
                            DatasyncMetainfoValue typeMeta = new DatasyncMetainfoValue();
                            typeMeta.setKey(MetaInfoKey.TYPE.toString());
                            typeMeta.setValue("INFOMAN_SOFTWARE");
                            value.addMetaInfoValue(typeMeta);
                        }
                        if (telitFile != null) {
                            DatasyncMetainfoValue modemTypeMeta = new DatasyncMetainfoValue();
                            modemTypeMeta.setKey(MetaInfoKey.MODEM_TYPE.toString());
                            modemTypeMeta.setValue(telitFile.getpName());
                            value.addMetaInfoValue(modemTypeMeta);
                            DatasyncMetainfoValue modemFirmwareVersionMeta = new DatasyncMetainfoValue();
                            modemFirmwareVersionMeta.setKey(MetaInfoKey.MODEM_FIRMWARE_VERSION.toString());
                            modemFirmwareVersionMeta.setValue(telitFile.getDisplaySwVersion());
                            value.addMetaInfoValue(modemFirmwareVersionMeta);
                        }
                        if (this.isAdditionalResourceUploadEnabled()) {
                            int index = this.resourceCBModel.getSize() - 1;
                            this.resourceCBModel.insertElementAt(value, index);
                            this.resourceCBModel.setSelectedItem(value);
                            break block24;
                        }
                        this.resourceCBModel.addElement(value);
                        this.resourceCBModel.setSelectedItem(value);
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "Could not add selected file (" + file.getAbsolutePath() + ") as Datasync resource", ex);
                        this.resourceCB.setSelectedItem(this.noResourceItemName);
                    }
                } else {
                    this.resourceCB.setSelectedItem(this.noResourceItemName);
                }
            }
        }
    }

    private void timeTFActionPerformed(ActionEvent evt) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    private void handleDocumentEvent(DocumentEvent e) {
        try {
            this.time = this.parseTime();
            this.errorLbl.setText("");
        }
        catch (Exception ex) {
            this.errorLbl.setText(NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.error.timeParse"));
        }
    }

    private class ResourceRenderer
    extends DefaultListCellRenderer {
        public ResourceRenderer() {
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DatasyncResourceValue) {
                String filename = NbBundle.getMessage(TimeResourceSelectorPanel.class, (String)"TimeResourceSelectorPanel.unknownFilename.text");
                DatasyncResourceValue datasyncResource = (DatasyncResourceValue)value;
                List metaValues = datasyncResource.getMetainfos();
                if (metaValues != null) {
                    for (DatasyncMetainfoValue val : metaValues) {
                        if (!val.getKey().equalsIgnoreCase(MetaInfoKey.FILE_NAME.toString())) continue;
                        String v = val.getValue();
                        if (v == null) {
                            v = "";
                        }
                        filename = v.toString();
                    }
                }
                String label = datasyncResource.getResourceName() + " (" + filename + ")";
                if (comp instanceof TextComponent) {
                    ((TextComponent)comp).setText(label);
                } else if (comp instanceof JLabel) {
                    ((JLabel)comp).setText(label);
                } else {
                    log.log(Level.WARNING, "DefaultListCellRenderer returned neither a TextComponent nor a JLabel, can not handle {0}", comp.toString());
                    return new JLabel(label);
                }
            }
            return comp;
        }
    }
}

