/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.gui;

import de.proveo.idm.core.gui.util.NotificationMessage;
import de.proveo.idm.core.gui.util.Validatable;
import de.proveo.idm.core.gui.util.ValidationListener;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddServerPanel
extends JPanel
implements DocumentListener,
Validatable,
HelpCtx.Provider {
    private static final Logger log = Logger.getLogger(AddServerPanel.class.getName());
    public static final String PROP_SERVER_NAME = "AddServerDialog.servername";
    public static final String PROP_SERVER_URL = "AddServerDialog.serverurl";
    public static final String PROP_VERSION = "AddServerDialog.version";
    protected final List<ValidationListener> listeners = new ArrayList<ValidationListener>();
    private List<JRadioButton> versionButtons = new ArrayList<JRadioButton>();
    private String singleVersion = null;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JTextField nameTF;
    private JTextField urlTF;
    private ButtonGroup versionButtonGroup;
    private JPanel versionsPnl;

    public AddServerPanel() {
        this.initComponents();
        this.nameTF.getDocument().addDocumentListener(this);
        this.urlTF.getDocument().addDocumentListener(this);
    }

    public AddServerPanel(List<String> versions) {
        this();
        if (versions.size() == 1) {
            this.singleVersion = versions.get(0);
            this.versionsPnl.add(new JLabel(this.singleVersion));
        } else {
            AbstractButton defaultSelection = null;
            for (String entry : versions) {
                JRadioButton btn = new JRadioButton(entry);
                this.versionButtonGroup.add(btn);
                this.versionsPnl.add(btn);
                this.versionButtons.add(btn);
                if (entry == null || !entry.trim().equals("Auto")) continue;
                defaultSelection = btn;
            }
            if (defaultSelection != null) {
                defaultSelection.setSelected(true);
            } else if (this.versionButtons.size() > 0) {
                this.versionButtons.get(0).setSelected(true);
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("de.proveo.idm.remote.server");
    }

    public String getServerName() {
        return this.nameTF.getText();
    }

    public String getServerURL() {
        String url = this.urlTF.getText();
        if (url.trim().length() == 0) {
            return url;
        }
        if (!url.contains("://")) {
            url = "http://" + url;
        }
        return url;
    }

    public String getVersion() {
        if (this.versionButtons.isEmpty()) {
            return this.singleVersion;
        }
        for (JRadioButton btn : this.versionButtons) {
            if (!btn.isSelected()) continue;
            return btn.getText();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValidationListener(ValidationListener l) {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotificationChanged() {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            for (ValidationListener l : this.listeners) {
                l.notificationChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireValidationChanged() {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            for (ValidationListener l : this.listeners) {
                l.validationChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValidationListener(ValidationListener l) {
        List<ValidationListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private boolean isURLValid() {
        boolean valid;
        String url = this.getServerURL();
        if (url.trim().length() == 0) {
            return false;
        }
        try {
            URL parsedURL = new URL(url);
            String protocol = parsedURL.getProtocol();
            valid = protocol.equals("http") || protocol.equals("https");
        }
        catch (Exception ex) {
            log.log(Level.INFO, "URL parsing problem: {0}", ex.getMessage());
            valid = false;
        }
        return valid;
    }

    private boolean isNameValid() {
        String name = this.getServerName();
        return name.trim().length() != 0;
    }

    public boolean checkValidation() {
        return this.isNameValid() && this.isURLValid();
    }

    public NotificationMessage getNotificationMessage() {
        if (!this.isNameValid()) {
            return new NotificationMessage(0, NbBundle.getMessage(AddServerPanel.class, (String)"AddServerPanel.error.invalidName"));
        }
        if (!this.isURLValid()) {
            return new NotificationMessage(0, NbBundle.getMessage(AddServerPanel.class, (String)"AddServerPanel.error.invalidURL"));
        }
        return null;
    }

    private void initComponents() {
        this.versionButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.nameTF = new JTextField();
        this.urlTF = new JTextField();
        this.jLabel5 = new JLabel();
        this.versionsPnl = new JPanel();
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(NbBundle.getMessage(AddServerPanel.class, (String)"AddServerPanel.jLabel1.text"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(NbBundle.getMessage(AddServerPanel.class, (String)"AddServerPanel.jLabel2.text"));
        this.nameTF.setColumns(20);
        this.urlTF.setColumns(20);
        this.jLabel5.setText(NbBundle.getMessage(AddServerPanel.class, (String)"AddServerPanel.jLabel5.text"));
        this.versionsPnl.setLayout(new FlowLayout(0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionsPnl, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.nameTF).addComponent(this.urlTF))).addContainerGap()));
        layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel5);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nameTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.urlTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.versionsPnl, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel5, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentEvent(e);
    }

    private void handleDocumentEvent(DocumentEvent e) {
        Document source = e.getDocument();
        if (source == this.nameTF.getDocument()) {
            this.firePropertyChange(PROP_SERVER_NAME, 0, 1);
        } else if (source == this.urlTF.getDocument()) {
            this.firePropertyChange(PROP_SERVER_URL, 0, 1);
        }
        this.fireValidationChanged();
    }
}

