/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.editors;

import de.proveo.idm.remote.server.api.EFMServerManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.Lookup;

public class VersionPropertyEditor
extends PropertyEditorSupport
implements InplaceEditor.Factory,
ExPropertyEditor {
    private InplaceEditor editor;
    private JComboBox versionsCB;
    private ArrayList<ActionListener> listener = new ArrayList();

    public InplaceEditor getInplaceEditor() {
        if (this.editor == null) {
            this.editor = new InplaceEditorImpl();
        }
        return this.editor;
    }

    public void attachEnv(PropertyEnv pe) {
        pe.registerInplaceEditorFactory((InplaceEditor.Factory)this);
    }

    private class InplaceEditorImpl
    implements InplaceEditor {
        private PropertyEditor editor;
        private PropertyModel model;
        private String defaultSelection;

        private InplaceEditorImpl() {
        }

        public void connect(PropertyEditor editor, PropertyEnv env) {
            this.editor = editor;
            this.defaultSelection = (String)editor.getValue();
        }

        public JComponent getComponent() {
            if (VersionPropertyEditor.this.versionsCB == null) {
                EFMServerManager sMgr = (EFMServerManager)Lookup.getDefault().lookup(EFMServerManager.class);
                List<String> versions = sMgr.getSupportedVersions();
                VersionPropertyEditor.this.versionsCB = new JComboBox<Object>(versions.toArray());
            }
            return VersionPropertyEditor.this.versionsCB;
        }

        public void clear() {
            this.editor = null;
            this.model = null;
            this.defaultSelection = null;
        }

        public Object getValue() {
            return VersionPropertyEditor.this.versionsCB.getSelectedItem();
        }

        public void setValue(Object o) {
            VersionPropertyEditor.this.versionsCB.setSelectedItem(o);
        }

        public boolean supportsTextEntry() {
            return false;
        }

        public void reset() {
            VersionPropertyEditor.this.versionsCB.setSelectedItem(this.defaultSelection);
        }

        public void addActionListener(ActionListener al) {
            VersionPropertyEditor.this.listener.add(al);
        }

        public void removeActionListener(ActionListener al) {
            VersionPropertyEditor.this.listener.remove(al);
        }

        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        public PropertyModel getPropertyModel() {
            return this.model;
        }

        public void setPropertyModel(PropertyModel pm) {
            this.model = pm;
        }

        public boolean isKnownComponent(Component cmpnt) {
            return cmpnt == VersionPropertyEditor.this.versionsCB;
        }
    }
}

