/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api.impl;

import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.navigation.api.RemoteNavigationItem;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.ServerFeatureProvider;
import de.proveo.idm.remote.server.api.UnitTreeElement;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import de.proveo.idm.remote.server.util.TreeUtil;
import java.util.Collection;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.NbBundle;

public class UnitsServerFeatureProvider
implements ServerFeatureProvider {
    private static final Logger log = Logger.getLogger(UnitsServerFeatureProvider.class.getName());

    @Override
    public NavigationItem createItemForServerTree(ProgressHandle handle, EFMServerNavigationItem serverItem) throws Exception {
        UnitTreeElement units;
        log.info("Fetching units ...");
        EFMServer server = serverItem.getServerInstance();
        Collection capabilities = server.getCapabilities();
        if (!this.isCapabilityFullfilled(capabilities)) {
            throw new UnsupportedOperationException("Capabilities not fullfilled!");
        }
        if (handle != null) {
            handle.setDisplayName(NbBundle.getMessage(UnitsServerFeatureProvider.class, (String)"UnitsServerFeatureProvider.fetchingUnits"));
        }
        if ((units = server.getUnits()) != null) {
            return TreeUtil.createUnitsNavigation(units.getChildren());
        }
        return null;
    }

    @Override
    public RemoteNavigationItem.Type getRemoteNavigationItemType() {
        return RemoteNavigationItem.Type.INSTALLED_DEVICES;
    }

    @Override
    public boolean isCapabilityFullfilled(Collection<Capability> capabilities) {
        return capabilities != null && capabilities.contains(Capability.UNIT_OVERVIEW);
    }
}

