/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.api;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.core.gui.navigation.api.SoftwareBundle;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationLoadingException;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationNotPresentException;
import de.proveo.idm.core.gui.navigation.api.exceptions.ConfigurationSavingException;
import de.proveo.idm.core.gui.navigation.api.exceptions.InvalidDeviceConfigurationException;
import de.proveo.idm.core.gui.navigation.api.exceptions.NotConnectedException;
import de.proveo.idm.core.gui.navigation.api.exceptions.PositionNotPresentException;
import de.proveo.idm.core.gui.navigation.api.impl.AbstractNavigationItem;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.util.Configuration;
import de.proveo.idm.core.util.GroovyUtil;
import de.proveo.idm.core.util.VersionsCompareUtil;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.util.RemoteUpdateHandler;
import de.proveo.idm.software.archive.api.AbstractInfomanEFMSoftwareBundle;
import de.proveo.idm.software.archive.api.InfomanEFMRead;
import de.proveo.idm.software.archive.api.InfomanSoftwareArchiveManager;
import de.proveo.idm.software.archive.util.ChecksumUtil;
import de.proveo.util.geo.GPSPosition;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public abstract class AbstractRemoteInfoman
extends AbstractNavigationItem
implements RemoteInfoman,
Cloneable {
    private static final Logger log = Logger.getLogger(AbstractRemoteInfoman.class.getName());
    protected String iconBase = "de/proveo/idm/remote/server/resources/Infoman.png";
    protected Device.DeviceType deviceType;
    protected RemoteDeviceId id;

    public AbstractRemoteInfoman(String name) {
        super(name, null);
    }

    private void appendATCommand(String cmd, InfomanEFMRead readScript, StringBuilder builder, String readResponse) {
        String[] keyValue = StringUtils.split((String)(readResponse = readScript.processCommandReadResponse(cmd, readResponse)), (char)':');
        if (keyValue.length == 2) {
            builder.append("AT");
            builder.append(keyValue[0].trim());
            builder.append("=");
            builder.append(keyValue[1].trim());
            builder.append("\n");
        } else if (keyValue.length > 2) {
            builder.append("AT");
            builder.append(keyValue[0].trim());
            builder.append("=");
            for (int i = 1; i < keyValue.length; ++i) {
                builder.append(keyValue[i].trim());
                if (i + 1 >= keyValue.length) continue;
                builder.append(":");
            }
            builder.append("\n");
        }
    }

    public abstract AbstractRemoteInfoman clone() throws CloneNotSupportedException;

    public Configuration openConfiguration(SoftwareBundle bundle) throws NotConnectedException, ConfigurationLoadingException, ConfigurationNotPresentException, InvalidDeviceConfigurationException {
        try {
            String configString;
            DatasyncResourceValue resValue = this.getConfiguration();
            if (resValue == null) {
                throw new ConfigurationNotPresentException("Could not get current configuration");
            }
            byte[] config = resValue.getResource();
            if (config == null) {
                throw new ConfigurationNotPresentException("Current configuration is empty");
            }
            boolean upToDate = true;
            List metaInfos = resValue.getMetainfos();
            if (metaInfos != null) {
                for (DatasyncMetainfoValue metaInfo : metaInfos) {
                    if (!metaInfo.getKey().equalsIgnoreCase(MetaInfoKey.UP_TO_DATE.toString())) continue;
                    upToDate = Boolean.parseBoolean(metaInfo.getValue());
                    break;
                }
            }
            String prefix = "tmp_remote_" + this.getName() + "_";
            String suffix = ".properties";
            if (Device.DeviceType.INFOMAN_EFM.equals((Object)this.getDeviceType())) {
                suffix = ".iefm";
                List configReadLines = IOUtils.readLines((InputStream)new ByteArrayInputStream(config));
                InputStream groovyScript = bundle.getResource("Read.groovy");
                InfomanEFMRead readScript = (InfomanEFMRead)GroovyUtil.loadGroovyScript((String)IOUtils.toString((InputStream)groovyScript), InfomanEFMRead.class);
                StringBuilder configWriteCommands = new StringBuilder();
                for (String line : configReadLines) {
                    line = line.trim();
                    String cmd = null;
                    int end = StringUtils.indexOf((String)line, (char)':');
                    if (end != -1) {
                        cmd = StringUtils.substring((String)line, (int)0, (int)end).trim();
                    }
                    this.appendATCommand(cmd, readScript, configWriteCommands, line);
                }
                configString = configWriteCommands.toString();
            } else {
                configString = new String(config);
            }
            File configurationFile = File.createTempFile(prefix, suffix);
            FileUtils.writeStringToFile((File)configurationFile, (String)configString);
            FileUtils.forceDeleteOnExit((File)configurationFile);
            Configuration configuration = new Configuration(this.getName() + " (" + this.getServer().getName() + ")", configurationFile, upToDate);
            configuration.setFilename(resValue.getResourceName());
            return configuration;
        }
        catch (Exception ex) {
            throw new ConfigurationLoadingException("Error while trying to download configuration", (Throwable)ex);
        }
    }

    public boolean saveConfiguration(File configuration) throws NotConnectedException, InvalidDeviceConfigurationException, ConfigurationSavingException {
        try {
            DatasyncTaskValue task;
            if (Device.DeviceType.INFOMAN_EFM.equals((Object)this.getDeviceType()) && !this.getServer().getCapabilities().contains(Capability.INFOMANEFM_CONFIG_UPDATE)) {
                DialogUtil.showErrorDialog((Object)NbBundle.getMessage(AbstractRemoteInfoman.class, (String)"AbstractRemoteInfoman.saveConfiguration.server"));
                return false;
            }
            boolean datasyncAllowed = this.getServer().getCapabilities().contains(Capability.RESOURCE_OVERVIEW);
            if (datasyncAllowed) {
                try {
                    datasyncAllowed = Device.DeviceType.INFOMAN_EFM.equals((Object)this.getDeviceType()) || Device.DeviceType.INFOMAN.equals((Object)this.getDeviceType()) && VersionsCompareUtil.isVersionGreaterOrEqual((String)this.getSoftwareVersion(), (String)"1.12.0");
                }
                catch (Exception ex) {
                    datasyncAllowed = false;
                }
            }
            if ((task = RemoteUpdateHandler.createDatasyncTask(datasyncAllowed, false, true, this, "Software")) != null) {
                String configurationName = configuration.getName();
                Device.DeviceType devType = this.getDeviceType();
                if (ObjectUtils.equals((Object)Device.DeviceType.INFOMAN_EFM, (Object)devType)) {
                    try {
                        String swVersion = this.getSoftwareVersion();
                        AbstractInfomanEFMSoftwareBundle bundle = null;
                        InfomanSoftwareArchiveManager manager = (InfomanSoftwareArchiveManager)Lookup.getDefault().lookup(InfomanSoftwareArchiveManager.class);
                        Collection bundles = manager.findInfomanEFMBundle(swVersion);
                        for (AbstractInfomanEFMSoftwareBundle b : bundles) {
                            if (!b.getVersion().equals(swVersion)) continue;
                            bundle = b;
                            break;
                        }
                        Configuration currentConfig = this.openConfiguration((SoftwareBundle)bundle);
                        File currentConfigFile = currentConfig.getFile();
                        List atCmds = FileUtils.readLines((File)configuration);
                        List currentATcmds = FileUtils.readLines((File)currentConfigFile);
                        ArrayList<String> diffATcmds = new ArrayList<String>();
                        for (String cmd : atCmds) {
                            if (!cmd.contains("=")) continue;
                            boolean cmdEqual = false;
                            String key = StringUtils.split((String)cmd, (String)"=")[0];
                            for (String currentCmd : currentATcmds) {
                                if (!currentCmd.startsWith(key) || !currentCmd.equals(cmd)) continue;
                                cmdEqual = true;
                                break;
                            }
                            if (cmdEqual) continue;
                            diffATcmds.add(cmd);
                        }
                        log.info("Diff update possible, asking user for diff update ...");
                        Object n = DialogUtil.showYesNoCancelQuestionDialog((Object)NbBundle.getMessage(AbstractRemoteInfoman.class, (String)"AbstractRemoteInfoman.performDiffUpdate.msg"), (String)NbBundle.getMessage(AbstractRemoteInfoman.class, (String)"AbstractRemoteInfoman.performDiffUpdate.title"));
                        if (DialogUtil.YES_OPTION.equals(n)) {
                            if (diffATcmds.isEmpty()) {
                                log.info("No update neccessary, configuration hasn't changed.");
                                return true;
                            }
                            log.info("Performing diff update.");
                            File tmpDiffConfigFile = File.createTempFile(configurationName + "_diff", "iefm");
                            FileUtils.forceDeleteOnExit((File)tmpDiffConfigFile);
                            FileUtils.writeLines((File)tmpDiffConfigFile, diffATcmds);
                            configuration = tmpDiffConfigFile;
                        } else {
                            if (DialogUtil.CANCEL_OPTION.equals(n)) {
                                log.info("User canceled configuration update.");
                                return false;
                            }
                            log.info("Performing full update.");
                        }
                    }
                    catch (Exception ex) {
                        log.log(Level.INFO, "Diff update not possible, because", ex);
                    }
                }
                ArrayList<DatasyncResourceValue> resources = new ArrayList<DatasyncResourceValue>(task.getResources());
                byte[] config = this.fileToByteArray(configuration);
                String checksum = ChecksumUtil.generateSHA1Checksum((byte[])config);
                DatasyncResourceValue resource = new DatasyncResourceValue();
                resource.setResource(config);
                resource.setResourceName(configurationName);
                resource.setChecksum(checksum);
                ArrayList<DatasyncMetainfoValue> metaInfos = new ArrayList<DatasyncMetainfoValue>();
                DatasyncMetainfoValue info = new DatasyncMetainfoValue();
                info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
                info.setValue("SHA1");
                metaInfos.add(info);
                info = new DatasyncMetainfoValue();
                info.setKey(MetaInfoKey.CHECKSUM.toString());
                info.setValue(checksum);
                metaInfos.add(info);
                info = new DatasyncMetainfoValue();
                info.setKey(MetaInfoKey.FILE_NAME.toString());
                info.setValue(configurationName);
                metaInfos.add(info);
                info = new DatasyncMetainfoValue();
                info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
                info.setValue("text/plain");
                metaInfos.add(info);
                info = new DatasyncMetainfoValue();
                info.setKey(MetaInfoKey.TYPE.toString());
                info.setValue("INFOMAN_CONFIG");
                metaInfos.add(info);
                resource.setMetainfos(metaInfos);
                resources.add(0, resource);
                task.setResources(resources);
                DatasyncTaskValue createdTask = this.getServer().getRemoteUpdateAdapter().createTask(this.getDeviceType(), task);
                if (createdTask != null) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            throw new ConfigurationSavingException("Error while trying to upload configuration to remote server", (Throwable)ex);
        }
    }

    protected byte[] fileToByteArray(File configuration) {
        try {
            return FileUtils.readFileToByteArray((File)configuration);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public GPSPosition getPosition() throws PositionNotPresentException {
        try {
            GPSPosition ret = null;
            long unitId = this.getUnitId();
            String posString = this.getServer().getUnitPosition(unitId);
            String[] posStringArray = StringUtils.split((String)posString, (char)'/');
            if (posStringArray.length == 2) {
                String value1 = posStringArray[0];
                String value2 = posStringArray[1];
                if (value1.startsWith("$GPRMC") && value2.startsWith("$GPGGA")) {
                    ret = new GPSPosition(value1, value2);
                } else {
                    int lati = Integer.parseInt(value1);
                    int longi = Integer.parseInt(value2);
                    ret = new GPSPosition(longi, lati);
                }
            } else {
                throw new PositionNotPresentException("No position available");
            }
            return ret;
        }
        catch (Exception ex) {
            throw new PositionNotPresentException("Failed to load position from server", (Throwable)ex);
        }
    }

    public boolean isVisibleOnMap() {
        try {
            if (this.getServer().getCapabilities().contains(Capability.MAPPING)) {
                return this.getServer().isUnitVisibleOnMap(this.getUnitId());
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setIconBase(String iconBase) {
        this.iconBase = iconBase;
    }

    public String getIconBaseWithExtension() {
        return this.iconBase;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractRemoteInfoman) {
            if (obj == this) {
                return true;
            }
            AbstractRemoteInfoman other = (AbstractRemoteInfoman)obj;
            long otherId = other.getUnitId();
            return this.getUnitId() == otherId;
        }
        return false;
    }

    public Device.DeviceType getDeviceType() {
        return this.deviceType;
    }

    @Override
    public RemoteDeviceId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getUnitId() {
        return this.id.getUnitId();
    }

    public String getSerialNumber() {
        return this.id.getSerialNumber();
    }

    public int hashCode() {
        return new Long(this.getUnitId()).hashCode();
    }

    public String toString() {
        return "#" + this.getUnitId() + " " + this.getName();
    }
}

