/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.actions.server;

import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.util.NotificationUtil;
import de.proveo.idm.licensing.api.PermissionHandler;
import de.proveo.idm.licensing.api.PermissionHandlerFactory;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LogoffAction
extends AbstractAction
implements ContextAwareAction {
    private EFMServerNavigationItem serverItem;

    public LogoffAction() {
        super(NbBundle.getMessage(LogoffAction.class, (String)"LogoffAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PermissionHandler pm = PermissionHandlerFactory.getDefault();
        pm.removePermissions((Object)this.serverItem);
        EFMServer server = this.serverItem.getServerInstance();
        server.logoff();
        ArrayList children = new ArrayList(this.serverItem.getChildren());
        for (NavigationItem child : children) {
            this.serverItem.removeChild(child);
        }
        NotificationUtil.notifyInfoAutoClear((String)NbBundle.getMessage(LogoffAction.class, (String)"LogoffAction.successful.title"), (String)NbBundle.getMessage(LogoffAction.class, (String)"LogoffAction.successful.msg", (Object)this.serverItem.getName()), (long)5000L);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        LogoffAction ret = new LogoffAction();
        EFMServerNavigationItem item = (EFMServerNavigationItem)actionContext.lookup(EFMServerNavigationItem.class);
        EFMServer server = item.getServerInstance();
        IDMLoginResponse response = null;
        if (server != null) {
            response = server.getLoginResponse();
        }
        ret.serverItem = item;
        ret.setEnabled(!item.isConnecting() && response != null && response.isAccessPermitted());
        return ret;
    }
}

