/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.actions.server;

import com.jcraft.jsch.JSchException;
import de.proveo.idm.core.gui.navigation.api.Capability;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.EFMServerData;
import de.proveo.idm.core.gui.navigation.api.NavigationItem;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.core.gui.util.NotificationUtil;
import de.proveo.idm.licensing.api.PermissionHandler;
import de.proveo.idm.licensing.api.PermissionHandlerFactory;
import de.proveo.idm.remote.server.api.EFMServer;
import de.proveo.idm.remote.server.api.EFMServerFactory;
import de.proveo.idm.remote.server.api.EFMServerManager;
import de.proveo.idm.remote.server.api.IDMLoginResponse;
import de.proveo.idm.remote.server.api.LoginDataProvider;
import de.proveo.idm.remote.server.api.ServerFeatureProvider;
import de.proveo.idm.remote.server.impl.ServerFinder;
import de.proveo.idm.remote.server.navigation.EFMServerNavigationItem;
import java.awt.event.ActionEvent;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class LoginAction
extends AbstractAction
implements ContextAwareAction {
    private static final Logger log = Logger.getLogger(LoginAction.class.getName());
    private EFMServerNavigationItem serverItem;

    public LoginAction() {
        super(NbBundle.getMessage(LoginAction.class, (String)"LoginAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PerformLogin login = new PerformLogin(this.serverItem);
        Thread thread = new Thread(login);
        thread.setName("Server Login");
        thread.start();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        LoginAction ret = new LoginAction();
        EFMServerNavigationItem item = (EFMServerNavigationItem)actionContext.lookup(EFMServerNavigationItem.class);
        EFMServer server = item.getServerInstance();
        IDMLoginResponse response = null;
        if (server != null) {
            response = server.getLoginResponse();
        }
        ret.serverItem = item;
        ret.setEnabled(!item.isConnecting() && (response == null || !response.isAccessPermitted()));
        return ret;
    }

    private class PerformLogin
    implements Runnable {
        private final EFMServerNavigationItem serverItem;
        private EFMServer server;
        private Collection<Capability> capabilities;
        private Credentials credentials;

        public PerformLogin(EFMServerNavigationItem server) {
            this.serverItem = server;
        }

        @Override
        public void run() {
            this.login();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void login() {
            String errorMessage = null;
            ProgressHandle handle = null;
            try {
                this.serverItem.setConnecting(true);
                String description = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.name");
                handle = ProgressHandleFactory.createHandle((String)String.format("%s: %s", description, this.serverItem.getName()));
                handle.start();
                handle.switchToIndeterminate();
                this.server = this.serverItem.getServerInstance();
                if (this.server == null) {
                    this.server = this.findServer();
                    if (this.server == null) {
                        return;
                    }
                }
                if (this.credentials == null) {
                    this.credentials = this.server.getIDMCredentials();
                }
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Starting login on {0} ({1})", new Object[]{this.server.getURL(), this.serverItem.getServerData().getVersion()});
                }
                LoginDataProvider provider = (LoginDataProvider)Lookup.getDefault().lookup(LoginDataProvider.class);
                if (this.credentials == null) {
                    this.credentials = provider.getLoginData(this.server.getName(), this.server.getURL());
                }
                if (this.credentials == null) {
                    return;
                }
                IDMLoginResponse response = this.server.login(this.credentials);
                this.capabilities = this.server.getCapabilities();
                while (response == null || !response.isAccessPermitted()) {
                    DialogUtil.showErrorDialog((Object)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.login.failed.msg"), (String)NbBundle.getMessage(EFMServer.class, (String)"EFMServer.login.failed.title"));
                    this.credentials = provider.getLoginData(this.server.getName(), this.server.getURL());
                    if (this.credentials == null) {
                        this.logoutAndLog(this.server, null);
                        return;
                    }
                    response = this.server.login(this.credentials);
                }
                if (response == null) return;
                if (!response.isAccessPermitted()) return;
                PermissionHandler pm = PermissionHandlerFactory.getDefault();
                List<String> permissions = response.getPermissions();
                if (permissions != null) {
                    permissions = new ArrayList<String>(permissions);
                    pm.setPermissions((Object)this.serverItem, permissions);
                }
                int progressCount = 0;
                Collection featureProviders = Lookup.getDefault().lookupAll(ServerFeatureProvider.class);
                handle.switchToDeterminate(featureProviders.size());
                for (ServerFeatureProvider fp : featureProviders) {
                    if (!fp.isCapabilityFullfilled(this.capabilities)) continue;
                    try {
                        NavigationItem item = fp.createItemForServerTree(handle, this.serverItem);
                        if (item != null) {
                            this.serverItem.addChild(item);
                        }
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "Could not create items for " + fp.getRemoteNavigationItemType(), ex);
                    }
                    handle.progress(progressCount++);
                }
                NotificationUtil.notifyInfoAutoClear((String)NbBundle.getMessage(LoginAction.class, (String)"LoginAction.successful.title"), (String)NbBundle.getMessage(LoginAction.class, (String)"LoginAction.successful.msg", (Object)this.serverItem.getName()), (long)5000L);
                return;
            }
            catch (ConnectException ex) {
                this.logoutAndLog(this.server, ex);
                errorMessage = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.error.login.connect");
                return;
            }
            catch (SocketTimeoutException ex) {
                this.logoutAndLog(this.server, ex);
                errorMessage = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.error.login.timeout");
                return;
            }
            catch (JSchException ex) {
                this.logoutAndLog(this.server, (Exception)((Object)ex));
                errorMessage = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.error.tunnel");
                return;
            }
            catch (ClientResponseFailure ex) {
                this.logoutAndLog(this.server, (Exception)((Object)ex));
                ClientResponse response = ex.getResponse();
                int status = response.getStatus();
                switch (status) {
                    case 400: {
                        errorMessage = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.error.login.connect");
                        return;
                    }
                    case 403: {
                        errorMessage = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.error.403");
                        return;
                    }
                }
                return;
            }
            catch (RuntimeException ex) {
                this.logoutAndLog(this.server, ex);
                Throwable cause = ex.getCause();
                if (cause instanceof ConnectException) {
                    errorMessage = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.error.login.connect");
                    return;
                }
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            catch (Exception ex) {
                this.logoutAndLog(this.server, ex);
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            finally {
                this.serverItem.setConnecting(false);
                if (handle != null) {
                    handle.finish();
                }
                if (errorMessage != null) {
                    DialogUtil.showErrorDialog((Object)errorMessage);
                }
            }
        }

        private EFMServer findServer() throws Exception {
            EFMServerData data = this.serverItem.getServerData();
            if (this.credentials == null) {
                LoginDataProvider login = (LoginDataProvider)Lookup.getDefault().lookup(LoginDataProvider.class);
                this.credentials = login.getLoginData(data.getServername(), data.getUrl());
            }
            if (this.credentials != null) {
                ServerFinder finder = new ServerFinder(data, this.credentials);
                EFMServerManager mgr = (EFMServerManager)Lookup.getDefault().lookup(EFMServerManager.class);
                Map<String, EFMServerFactory> factories = mgr.getAvailableServerAdapters();
                String version = finder.findVersion(data.getUrl());
                while (version != null) {
                    EFMServerFactory factory = factories.get(version);
                    if (factory != null) {
                        data.setVersion(version);
                        EFMServer foundServer = this.serverItem.getServerInstance();
                        return foundServer;
                    }
                    Collection<EFMServerFactory> factoriesList = factories.values();
                    for (EFMServerFactory f : factoriesList) {
                        if (!f.canHandleVersion(version)) continue;
                        data.setVersion(f.getName());
                        EFMServer foundServer = this.serverItem.getServerInstance();
                        return foundServer;
                    }
                    String msg = NbBundle.getMessage(LoginAction.class, (String)"LoginAction.finderDialog.message", (Object)version);
                    version = finder.askForVersion(msg);
                }
            }
            return null;
        }

        private void logoutAndLog(EFMServer server, Exception ex) {
            if (server != null) {
                server.logoff();
            }
            this.credentials = null;
            if (ex != null) {
                log.log(Level.SEVERE, "Login runs into", ex);
            }
        }
    }
}

