/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.threadPool;

import de.proveo.util.threadPool.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class WorkerThread
extends Thread {
    private static final Log log = LogFactory.getLog(WorkerThread.class);
    protected ThreadPool threadPool;

    public WorkerThread(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public void run() {
        Runnable target = null;
        do {
            try {
                target = this.threadPool.getAssignment();
                if (target == null) continue;
                target.run();
            }
            catch (Throwable ex) {
                log.error((Object)("Error while trying to execute runnable: " + target), ex);
            }
        } while (!this.threadPool.isShutdown());
        log.debug((Object)("WorkerThread (" + this + ") stopped. (ThreadPool: " + this.threadPool + ")"));
    }
}

