/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.string;

import java.util.Locale;

public class StringUtil {
    public static int countOccurrences(String string, char ch) {
        char[] array = string.toCharArray();
        int count = 0;
        for (char c : array) {
            if (c != ch) continue;
            ++count;
        }
        return count;
    }

    public static String fillUpLeading(String string, char ch, int totalLength) {
        StringBuilder sb = new StringBuilder(totalLength);
        int charCount = totalLength - string.length();
        while (charCount-- > 0) {
            sb.append(ch);
        }
        return sb.append(string).toString();
    }

    public static String fillUpTrailing(String string, char ch, int totalLength) {
        StringBuilder sb = new StringBuilder(totalLength);
        sb.append(string);
        int charCount = totalLength - string.length();
        while (charCount-- > 0) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("main start.");
        String str = "z1\nz2";
        str = StringUtil.removeCRLF(str);
    }

    public static String removeCRLF(String str) {
        return str.replaceAll("[\\r\\n]", "");
    }

    @Deprecated
    public static String replace(String str, String token, String value, boolean allAppearance) {
        int start = 0;
        int end = 0;
        boolean cont = true;
        while (cont) {
            start = str.indexOf(token);
            if (start >= 0) {
                end = start + token.length();
                str = str.substring(0, start) + value + str.substring(end, str.length());
                if (allAppearance) continue;
                cont = false;
                continue;
            }
            cont = false;
        }
        return str;
    }

    public static String roundString(double value, int decimalPlaces) {
        String expression = StringUtil.appendStrings("%.", String.valueOf(decimalPlaces), "f");
        return String.format(Locale.US, expression, value);
    }

    public static final String appendStrings(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != strings.length; ++i) {
            if (strings[i] == null) continue;
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    public static String truncate(String string, int maxLength) {
        return string.length() > maxLength ? string.substring(0, maxLength) : string;
    }

    public static String escapeNonLatin1Characters(String source) {
        StringBuffer result = new StringBuffer();
        for (char c : source.toCharArray()) {
            if (c >= ' ' && c <= '~' || c >= '\u00a0' && c <= '\u00ff') {
                result.append(c);
                continue;
            }
            result.append(String.format("\\x%04X", c));
        }
        return result.toString();
    }
}

