/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.servlet.resume;

import de.proveo.util.servlet.ByteArrayServletResponseWrapper;
import de.proveo.util.servlet.resume.Range;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResumeDownloadFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ResumeDownloadFilter.class);

    public void init(FilterConfig fc) throws ServletException {
    }

    public void destroy() {
    }

    int getRangeLength(Range range, byte[] responseContent) {
        if (range.endIndex < 0) {
            return responseContent.length - range.beginIndex;
        }
        return range.endIndex - range.beginIndex + 1;
    }

    Range parseRange(HttpServletRequest request) {
        String rangeHeaderValue = StringUtils.trimToNull((String)request.getHeader("Range"));
        if (rangeHeaderValue == null) {
            return null;
        }
        Range range = new Range();
        String[] values = StringUtils.split((String)rangeHeaderValue, (String)"=-");
        range.beginIndex = Integer.parseInt(values[1]);
        if (values.length > 2) {
            range.endIndex = Integer.parseInt(values[2]);
        }
        return range;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Range range = this.parseRange((HttpServletRequest)request);
        if (range == null) {
            chain.doFilter(request, response);
        } else {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            ByteArrayServletResponseWrapper wrappedResponse = new ByteArrayServletResponseWrapper(httpResponse);
            chain.doFilter(request, (ServletResponse)wrappedResponse);
            byte[] responseContent = wrappedResponse.toByteArray();
            int rangeLength = this.getRangeLength(range, responseContent);
            httpResponse.setStatus(206);
            httpResponse.setHeader("Content-Range", this.formatContentRange(range, rangeLength, responseContent));
            httpResponse.getOutputStream().write(responseContent, range.beginIndex, rangeLength);
        }
    }

    String formatContentRange(Range range, int rangeLength, byte[] resource) {
        StringBuilder buffer = new StringBuilder("bytes ");
        buffer.append(range.beginIndex);
        buffer.append("-");
        buffer.append(range.beginIndex + rangeLength - 1);
        buffer.append("/");
        buffer.append(resource.length);
        return buffer.toString();
    }
}

