/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.servlet.header;

import de.proveo.util.servlet.header.HeaderFilterResponseWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class HeaderFilter
implements Filter {
    private final Set<String> filteredHeaders = new HashSet<String>();

    public void destroy() {
        this.filteredHeaders.clear();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HeaderFilterResponseWrapper wrappedResponse = new HeaderFilterResponseWrapper((HttpServletResponse)response, this.filteredHeaders);
        chain.doFilter(request, (ServletResponse)wrappedResponse);
    }

    public void init(FilterConfig filterConfig) {
        this.filteredHeaders.clear();
        String value = filterConfig.getInitParameter("header");
        if (value != null) {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                this.filteredHeaders.add(tokenizer.nextToken().trim());
            }
        }
    }
}

