/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.servlet.comp;

import de.proveo.util.servlet.comp.CompressionServletResponseWrapper;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CompressionFilter
implements Filter {
    protected int compressionThreshold;
    private FilterConfig config = null;
    private int debug = 0;
    private int minThreshold = 128;

    public void destroy() {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.debug > 0) {
            System.out.println("@doFilter");
        }
        if (this.compressionThreshold == 0) {
            if (this.debug > 0) {
                System.out.println("doFilter gets called, but compressionTreshold is set to 0 - no compression");
            }
            chain.doFilter(request, response);
            return;
        }
        boolean supportCompression = false;
        if (request instanceof HttpServletRequest) {
            String s;
            if (this.debug > 1) {
                System.out.println("requestURI = " + ((HttpServletRequest)request).getRequestURI());
            }
            if ("false".equals(s = ((HttpServletRequest)request).getParameter("gzip"))) {
                if (this.debug > 0) {
                    System.out.println("got parameter gzip=false --> don't compress, just chain filter");
                }
                chain.doFilter(request, response);
                return;
            }
            Enumeration e = ((HttpServletRequest)request).getHeaders("Accept-Encoding");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.indexOf("gzip") != -1) {
                    if (this.debug > 0) {
                        System.out.println("supports compression");
                    }
                    supportCompression = true;
                    continue;
                }
                if (this.debug <= 0) continue;
                System.out.println("no support for compresion");
            }
        }
        if (!supportCompression) {
            if (this.debug > 0) {
                System.out.println("doFilter gets called wo compression");
            }
            chain.doFilter(request, response);
            return;
        }
        if (response instanceof HttpServletResponse) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper((HttpServletResponse)response);
            wrappedResponse.setDebugLevel(this.debug);
            wrappedResponse.setCompressionThreshold(this.compressionThreshold);
            if (this.debug > 0) {
                System.out.println("doFilter gets called with compression");
            }
            try {
                chain.doFilter(request, (ServletResponse)wrappedResponse);
            }
            finally {
                wrappedResponse.finishResponse();
            }
            return;
        }
    }

    public FilterConfig getFilterConfig() {
        return this.config;
    }

    public void init(FilterConfig filterConfig) {
        this.config = filterConfig;
        if (filterConfig != null) {
            String value = filterConfig.getInitParameter("debug");
            this.debug = value != null ? Integer.parseInt(value) : 0;
            String str = filterConfig.getInitParameter("compressionThreshold");
            if (str != null) {
                this.compressionThreshold = Integer.parseInt(str);
                if (this.compressionThreshold != 0 && this.compressionThreshold < this.minThreshold) {
                    if (this.debug > 0) {
                        System.out.println("compressionThreshold should be either 0 - no compression or >= " + this.minThreshold);
                        System.out.println("compressionThreshold set to " + this.minThreshold);
                    }
                    this.compressionThreshold = this.minThreshold;
                }
            } else {
                this.compressionThreshold = 0;
            }
        } else {
            this.compressionThreshold = 0;
        }
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }
}

