/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.security;

import de.proveo.util.ByteUtil;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LoginUtil {
    private static final Log log = LogFactory.getLog(LoginUtil.class);
    public static final String DEF_MESSAGE_DIGEST_INSTANCE = "SHA-1";

    private LoginUtil() {
    }

    public static String createMessageDigest(char[] password) {
        return LoginUtil.createMessageDigest(password, DEF_MESSAGE_DIGEST_INSTANCE);
    }

    public static String createMessageDigest(char[] password, String messageDigest) {
        int i;
        if (log.isTraceEnabled()) {
            log.trace((Object)"createMessageDigest()");
        }
        String passwordHash = null;
        CharArrayReader reader = new CharArrayReader(password);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int ch;
            while ((ch = reader.read()) != -1) {
                baos.write(ch);
            }
            reader.close();
        }
        catch (IOException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        byte[] passwordBytes = baos.toByteArray();
        try {
            MessageDigest md = MessageDigest.getInstance(messageDigest);
            byte[] output = md.digest(passwordBytes);
            passwordHash = ByteUtil.toHexString(output);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"runs into", (Throwable)e);
            throw new IllegalStateException("No " + messageDigest + " implementation found!");
        }
        for (i = 0; i < password.length; ++i) {
            password[i] = '\u0000';
        }
        for (i = 0; i < passwordBytes.length; ++i) {
            passwordBytes[i] = 0;
        }
        password = null;
        passwordBytes = null;
        return passwordHash;
    }
}

