/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.rest.interfaces;

import de.proveo.domain.values.admin.ObjectNodeBean;
import de.proveo.domain.values.infoman.InfomanSetupValue;
import de.proveo.domain.values.infoman.InfomanSoftwareValue;
import de.proveo.domain.values.infoman.LegacyScheduledUpdateValue;
import de.proveo.util.unit.tree.UnitTreeNodeBean;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="unit")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public interface UnitWebServiceClient {
    @GET
    @Path(value="installed")
    public UnitTreeNodeBean getInstalledUnits() throws Exception;

    @GET
    @Path(value="notInstalledDevices")
    public List<ObjectNodeBean> getNotInstalledDevices();

    @GET
    @Path(value="{id}/config")
    public InfomanSetupValue getConfiguration(@PathParam(value="id") long var1) throws Exception;

    @GET
    @Path(value="availableSoftware")
    public Collection<InfomanSoftwareValue> getAvailableSoftware();

    @GET
    @Path(value="{id}/softwareArchive")
    public byte[] getSoftwareArchive(@PathParam(value="id") long var1) throws Exception;

    @GET
    @Path(value="{id}/ipAddress")
    public String getUnitIpAddress(@PathParam(value="id") long var1);

    @GET
    @Path(value="{id}/position")
    public String getUnitPosition(@PathParam(value="id") long var1);

    @GET
    @Path(value="{id}/unitVisibleOnMap")
    public String isUnitVisibleOnMap(@PathParam(value="id") long var1);

    @POST
    @Path(value="legacy/createConfig")
    public void createLegacyInfomanUpdate(LegacyScheduledUpdateValue var1) throws Exception;

    @POST
    @Path(value="{id}/aclUpdate")
    public void forceACLUpdate(@PathParam(value="id") long var1) throws Exception;

    @POST
    @Path(value="{id}/callback")
    public void setCallbackFlag(@PathParam(value="id") long var1);

    @POST
    @Path(value="{id}/imei")
    public void setIMEI(@PathParam(value="id") long var1, @HeaderParam(value="imei") String var3);

    @POST
    @Path(value="{id}/serialNumber")
    public void setSerialNumber(@PathParam(value="id") long var1, @HeaderParam(value="serialNumber") String var3);

    @POST
    @Path(value="assign/{id}/{unitType}/{serialNumber}")
    public void assignToUnit(@PathParam(value="unitType") String var1, @PathParam(value="serialNumber") String var2, @PathParam(value="id") long var3);

    @GET
    @Path(value="{id}/zeroconf")
    public ObjectNodeBean getNotInstalledUnitById(@PathParam(value="id") int var1);
}

