/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.observable.connection;

import de.proveo.util.connection.ServletConnectionException;
import de.proveo.util.observable.interfaces.ClientListener;
import de.proveo.util.observable.interfaces.ClientWatchdog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionReader
extends Thread {
    private static final Log log = LogFactory.getLog(ConnectionReader.class);
    private ClientWatchdog clientWatchdog = null;
    private ClientListener clientListener = null;
    private Object object = null;
    private ObjectInputStream objectInputStream = null;
    private boolean compression = true;
    private boolean isRunning = true;

    public ConnectionReader(ObjectInputStream ois) {
        this.objectInputStream = ois;
        this.setName("ConnectionReader");
    }

    public void setListener(ClientListener cl) {
        this.clientListener = cl;
    }

    public void setWatchdog(ClientWatchdog cw) {
        this.clientWatchdog = cw;
    }

    public void closeThread() {
        String method = "closeThread(): ";
        this.isRunning = false;
        this.clientListener = null;
        log.debug((Object)(method + this.toString() + ": ConnectionReader-Object will be deleted by garbage collector!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String method = "run(): ";
        while (this.isRunning) {
            try {
                this.object = this.objectInputStream.readObject();
                if (this.compression) {
                    this.object = this.uncompressObj(this.object);
                }
                if (this.object == null || !this.isRunning) continue;
                this.forwardObject(this.object);
            }
            catch (IOException ioe) {
                if (!this.isRunning) {
                    log.debug((Object)(method + "Connection closed"));
                    continue;
                }
                log.debug((Object)(method + "lost connection to ObjectInputStream"));
                try {
                    if (this.isRunning && this.clientListener != null) {
                        log.warn((Object)(method + "try to re-connect to ObjectInputStream because of: IOException: " + ioe.getMessage()), (Throwable)ioe);
                        if (this.clientWatchdog != null) {
                            this.clientWatchdog.setIdle(true);
                        }
                        this.clientListener.reconnect(this);
                        continue;
                    }
                    log.debug((Object)(method + "thread finished"));
                }
                catch (ServletConnectionException sce) {
                    log.error((Object)(method + "Can not connect to servlet! (" + sce.getMessage() + ")"));
                }
                finally {
                    if (this.clientWatchdog == null) continue;
                    this.clientWatchdog.setIdle(false);
                }
            }
            catch (ClassNotFoundException cnfe) {
                log.error((Object)(method + "runs into ClassNotFoundException:"), (Throwable)cnfe);
            }
            finally {
                if (this.clientWatchdog == null) continue;
                if (this.isRunning && this.clientWatchdog.isIdle()) {
                    this.clientWatchdog.setIdle(false);
                    continue;
                }
                if (this.isRunning || this.clientWatchdog.isIdle()) continue;
                log.debug((Object)(method + "ConnectionReader was stopped normally. No one will check the connection (WatchDog will sleep)!"));
                this.clientWatchdog.setIdle(true);
            }
        }
    }

    protected void finalize() {
        log.debug((Object)("finalize(): Object " + this.toString() + " deleted by garbage collector!"));
    }

    private Object uncompressObj(Object obj) {
        Object uncompressedObj = null;
        try {
            ByteArrayInputStream arrayInputStream = new ByteArrayInputStream((byte[])obj);
            GZIPInputStream gZIPinputStream = new GZIPInputStream(arrayInputStream);
            ObjectInputStream ois = new ObjectInputStream(gZIPinputStream);
            uncompressedObj = ois.readObject();
            gZIPinputStream.close();
            ois.close();
        }
        catch (Throwable e) {
            this.compression = false;
            return obj;
        }
        return uncompressedObj;
    }

    private void forwardObject(Object object) {
        try {
            this.clientListener.setObject(object);
        }
        catch (Throwable e) {
            log.error((Object)("forwardObject() - " + this.toString() + ": Error while working with clientListener object!"), e);
        }
    }
}

