/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.math.angle.impl;

import de.proveo.util.math.angle.AngleParser;

public class DegreeAngleParser
implements AngleParser {
    @Override
    public double parse(String angle) throws NumberFormatException {
        String hemString;
        if (angle == null) {
            throw new IllegalArgumentException("parameter angle cannot be null");
        }
        int index = angle.indexOf(176);
        if (index > -1) {
            angle = angle.substring(0, index);
        }
        if ((angle = angle.trim()).equals("")) {
            return 0.0;
        }
        if (index + 1 < (angle = angle.replace(',', '.')).length() && ((hemString = angle.substring(index + 1).trim()).equals("W") || hemString.equals("S"))) {
            return Double.parseDouble(angle) * -1.0;
        }
        return Double.parseDouble(angle);
    }

    @Override
    public int parseIntoMS(String angle) throws NumberFormatException {
        int pos = angle.indexOf(176) + 1;
        int ret = (int)(this.parse(angle) * 3600.0 * 1000.0);
        if (pos < angle.length()) {
            String hemString = angle.substring(pos).trim();
            if (hemString.equals("W") || hemString.equals("S")) {
                ret *= -1;
                ret = (int)((double)ret - 0.5);
            }
        } else {
            ret = (int)((double)ret + 0.5);
        }
        return ret;
    }
}

