/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.math;

import de.proveo.util.math.Line;
import de.proveo.util.math.Point;

public class LineMath {
    public static final int ON_LINE = 0;
    public static final int LEFT_CRACK = 10;
    public static final int RIGHT_CRACK = 20;

    private LineMath() {
    }

    public static int crack(Point p1, Point p2, Point p3) {
        double determinat = LineMath.determinant(p1, p2, p3);
        if (determinat > 0.0) {
            return 10;
        }
        if (determinat < 0.0) {
            return 20;
        }
        return 0;
    }

    public static boolean intersect(Line l1, Line l2) {
        Point a = l1.getBegin();
        Point b = l1.getEnd();
        Point c = l2.getBegin();
        Point d = l2.getEnd();
        int crackABC = LineMath.crack(a, b, c);
        int crackABD = LineMath.crack(a, b, d);
        int crackCDB = LineMath.crack(c, d, b);
        int crackCDA = LineMath.crack(c, d, a);
        if (crackABC == 10 && crackABD == 20 && crackCDB == 10 && crackCDA == 20) {
            return true;
        }
        return crackABC == 20 && crackABD == 10 && crackCDB == 20 && crackCDA == 10;
    }

    protected static double determinant(Point p1, Point p2, Point p3) {
        double prod1 = p1.getX() * p2.getY();
        double prod2 = p1.getX() * p3.getY();
        double prod3 = p1.getY() * p3.getX();
        double prod4 = p1.getY() * p2.getX();
        double prod5 = p2.getX() * p3.getY();
        double prod6 = p2.getY() * p3.getX();
        return prod1 - prod2 + prod3 - prod4 + prod5 - prod6;
    }
}

