/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.kml.processors;

import de.proveo.util.kml.structs.ImageProperties;
import de.proveo.util.kml.structs.ValueGrid;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValueGridImageProcessor {
    private static final Log log = LogFactory.getLog(ValueGridImageProcessor.class);
    public static final Color NO_DATA_COLOR = new Color(0xFFFFFF, true);
    private ImageProperties imageProperties;

    public ValueGridImageProcessor() {
        this.imageProperties = new ImageProperties();
    }

    public ValueGridImageProcessor(ImageProperties imageProperties) {
        this.imageProperties = imageProperties;
    }

    public byte[] writeImage(ValueGrid coverageGrid) {
        int height = coverageGrid.getNumLatRects() * this.imageProperties.getScalingFactor();
        int width = coverageGrid.getNumLonRects() * this.imageProperties.getScalingFactor();
        BufferedImage bufferedImage = new BufferedImage(width * this.imageProperties.getScalingFactor(), height * this.imageProperties.getScalingFactor(), 2);
        int numLatRects = coverageGrid.getNumLatRects();
        int numLonRects = coverageGrid.getNumLonRects();
        for (int lonIdx = 0; lonIdx != numLonRects; ++lonIdx) {
            for (int latIdx = 0; latIdx != numLatRects; ++latIdx) {
                int yPos = latIdx * this.imageProperties.getScalingFactor();
                int xPos = lonIdx * this.imageProperties.getScalingFactor();
                int color = this.imageProperties.getColorValue(coverageGrid.getValue(latIdx, lonIdx));
                for (int x = 0; x != this.imageProperties.getScalingFactor(); ++x) {
                    for (int y = 0; y != this.imageProperties.getScalingFactor(); ++y) {
                        int xCoord = this.imageProperties.getScalingFactor() * xPos;
                        int yCoord = this.imageProperties.getScalingFactor() * (numLatRects - 1) - yPos + y;
                        bufferedImage.setRGB(xCoord, yCoord, color);
                    }
                }
            }
        }
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            data = baos.toByteArray();
        }
        catch (IOException e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return data;
    }
}

