/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.kml.processors;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.Boundary;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Geometry;
import de.micromata.opengis.kml.v_2_2_0.LineStyle;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import de.micromata.opengis.kml.v_2_2_0.Polygon;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.StyleSelector;
import de.micromata.opengis.kml.v_2_2_0.TimeSpan;
import de.proveo.util.kml.KmlUtil;
import de.proveo.util.kml.structs.GeoPoint;
import de.proveo.util.kml.structs.ImageProperties;
import de.proveo.util.kml.structs.ValueGrid;
import java.io.Serializable;
import java.text.SimpleDateFormat;

public class ValueGridBarProcessor {
    private BarProperties barProperties;
    private ImageProperties imageProperties;
    private static SimpleDateFormat xmlDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public ValueGridBarProcessor() {
        this.barProperties = new BarProperties();
        this.imageProperties = new ImageProperties();
    }

    public ValueGridBarProcessor(BarProperties barProperties, ImageProperties imageProperties) {
        this.barProperties = barProperties;
        this.imageProperties = imageProperties;
    }

    public void addBars(Folder folder, ValueGrid valueGrid) {
        this.addBars(folder, valueGrid, 0L, 0L);
    }

    public void addBars(Folder folder, ValueGrid valueGrid, long beginTime, long endTime) {
        if (beginTime != 0L && endTime != 0L) {
            TimeSpan timeSpan = folder.createAndSetTimeSpan();
            timeSpan.setBegin(xmlDateFormat.format(beginTime));
            timeSpan.setEnd(xmlDateFormat.format(endTime));
        }
        int numLatRects = valueGrid.getNumLatRects();
        int numLonRects = valueGrid.getNumLonRects();
        for (int lonIdx = 0; lonIdx != numLonRects; ++lonIdx) {
            for (int latIdx = 0; latIdx != numLatRects; ++latIdx) {
                long count = valueGrid.getCount(latIdx, lonIdx);
                if (count == -1L || count == 0L) continue;
                double height = this.barProperties.heightStep * (double)count;
                if (height > this.barProperties.getMaxHeight()) {
                    height = this.barProperties.getMaxHeight();
                }
                GeoPoint[] geoPoints = new GeoPoint[]{new GeoPoint(valueGrid.getMinLatForRect(latIdx), valueGrid.getMinLonForRect(lonIdx)), new GeoPoint(valueGrid.getMinLatForRect(latIdx), valueGrid.getMaxLonForRect(lonIdx)), new GeoPoint(valueGrid.getMaxLatForRect(latIdx), valueGrid.getMaxLonForRect(lonIdx)), new GeoPoint(valueGrid.getMaxLatForRect(latIdx), valueGrid.getMinLonForRect(lonIdx))};
                Boundary boundary = new Boundary();
                boundary.setLinearRing(KmlUtil.createLinearRing(geoPoints, height));
                Polygon polygon = new Polygon();
                polygon.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
                polygon.setExtrude(Boolean.valueOf(true));
                polygon.setOuterBoundaryIs(boundary);
                PolyStyle polyStyle = new PolyStyle();
                polyStyle.setColor(KmlUtil.kmlColor(this.imageProperties.getColor(count)));
                polyStyle.setFill(Boolean.valueOf(true));
                polyStyle.setOutline(Boolean.valueOf(true));
                LineStyle lineStyle = new LineStyle();
                lineStyle.setColor("99000000");
                lineStyle.setWidth(1.0);
                Style style = new Style();
                style.setPolyStyle(polyStyle);
                style.setLineStyle(lineStyle);
                Placemark placemark = new Placemark();
                placemark.setName(count + " event(s)");
                placemark.setDescription("");
                placemark.setGeometry((Geometry)polygon);
                placemark.addToStyleSelector((StyleSelector)style);
                folder.addToFeature((Feature)placemark);
            }
        }
    }

    public static class BarProperties
    implements Serializable {
        private static final long serialVersionUID = -7501939875587230994L;
        private long minValue = 0L;
        private long maxValue = 100L;
        private double minHeight = 0.0;
        private double maxHeight = 600.0;
        private double heightStep;

        public BarProperties() {
            this.updateHeightStep();
        }

        public BarProperties(long minValue, long maxValue, double minHeight, double maxHeight) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.updateHeightStep();
        }

        private void updateHeightStep() {
            this.heightStep = this.maxHeight / (double)(this.maxValue - this.minValue);
        }

        public long getMinValue() {
            return this.minValue;
        }

        public void setMinValue(long minValue) {
            this.minValue = minValue;
        }

        public long getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(long maxValue) {
            this.maxValue = maxValue;
        }

        public double getMinHeight() {
            return this.minHeight;
        }

        public void setMinHeight(double minHeight) {
            this.minHeight = minHeight;
        }

        public double getMaxHeight() {
            return this.maxHeight;
        }

        public void setMaxHeight(double maxHeight) {
            this.maxHeight = maxHeight;
        }

        public double getHeightStep() {
            return this.heightStep;
        }
    }
}

