/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.jpa.entity;

import de.proveo.util.jpa.entity.Relation;
import de.proveo.util.jpa.entity.Trim;
import de.proveo.util.reflection.ReflectionUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@MappedSuperclass
public abstract class EntityBase
implements Serializable {
    private static final long serialVersionUID = -4941668943197370433L;
    private static final Log log = LogFactory.getLog(EntityBase.class);
    private transient RelationInfo relationInfo = null;
    private transient Field[] trimFields = null;

    public abstract Object getPrimaryKey();

    public abstract String getName();

    public String toAuditString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.getPrimaryKey());
        sb.append("] ");
        sb.append(this.getName());
        return sb.toString();
    }

    @PrePersist
    private void prePersist() {
        this.trimFields();
    }

    @PreUpdate
    private void preUpdate() {
        this.trimFields();
    }

    private void trimFields() {
        if (this.trimFields == null) {
            this.trimFields = ReflectionUtil.getAnnotatedFields(this.getClass(), Trim.class);
        }
        for (Field field : this.trimFields) {
            Object o = ReflectionUtil.getFieldContent(field, this);
            if (o == null) continue;
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("@Trim can only be applied to String fields: " + this.getClass().getName() + "." + field.getName());
            }
            ReflectionUtil.setFieldContent(field, this, ((String)o).trim());
        }
    }

    public <T extends EntityBase> RelationPair getRelationPair(Class<? extends EntityBase> type, String targetName) {
        RelationInfo relationInfo = this.getRelationInfo();
        boolean duplicateType = relationInfo.duplicateTypes.contains(type);
        if (duplicateType && targetName == null) {
            throw new IllegalArgumentException("Ambigous class type for relations detected! Use of targetName argument for '" + type.toString() + "' required.");
        }
        RelationPair relationPair = null;
        relationPair = duplicateType ? this.getDuplicateFieldInstance(type, targetName, relationInfo) : this.getFieldInstance(type, relationInfo);
        if (relationPair == null) {
            log.error((Object)("No related field information found for " + type.toString()));
        }
        return relationPair;
    }

    private RelationPair getDuplicateFieldInstance(Class<? extends EntityBase> type, String targetName, RelationInfo relationInfo) {
        RelationPair[] relationPairs = this.filterFields(relationInfo.relationFields, type);
        ArrayList<String> targetNames = new ArrayList<String>();
        for (int i = 0; i != relationPairs.length; ++i) {
            String name = relationInfo.targetNames.get(relationPairs[i].relation);
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException("Ambigous class type for relations detected! Please specify valid targetName in @Relation.");
            }
            targetNames.add(name);
        }
        RelationPair relationPair = null;
        for (int i = 0; i != relationPairs.length; ++i) {
            if (!relationPairs[i].relation.getName().equals(targetName)) continue;
            relationPair = relationPairs[i];
            break;
        }
        if (relationPair == null) {
            throw new IllegalArgumentException("Wrong targetName passed to method. No match found for '" + targetName + "' in @Relation.");
        }
        return relationPair;
    }

    private RelationPair getFieldInstance(Class<? extends EntityBase> type, RelationInfo relationInfo) {
        RelationPair relationPair = null;
        RelationPair[] relationField = relationInfo.relationFields;
        int size = relationField.length;
        for (int i = 0; i != size; ++i) {
            relationPair = relationField[i];
            if (this.getTargetEntity(relationPair.relation) == type) break;
        }
        return relationPair;
    }

    private Class<?> getTargetEntity(Field field) {
        Class targetEntity = null;
        ManyToMany annotation = field.getAnnotation(ManyToMany.class);
        if (annotation != null) {
            targetEntity = annotation.targetEntity();
        } else {
            annotation = field.getAnnotation(OneToMany.class);
            if (annotation != null) {
                targetEntity = ((OneToMany)annotation).targetEntity();
            } else {
                annotation = field.getAnnotation(ManyToOne.class);
                if (annotation != null) {
                    targetEntity = ((ManyToOne)annotation).targetEntity();
                } else {
                    annotation = field.getAnnotation(OneToOne.class);
                    if (annotation != null) {
                        targetEntity = ((OneToOne)annotation).targetEntity();
                    }
                }
            }
        }
        if (targetEntity == Void.TYPE) {
            throw new IllegalArgumentException("targetEntity not set in relation annotation (@ManyToMany, @OneToMany, @ManyToOne, @OneToOne) of field " + this.getClass().getName() + "." + field.getName());
        }
        return targetEntity;
    }

    private static Field[] removeNonRelations(Field[] fields) {
        int size = fields.length;
        ArrayList<Field> list = new ArrayList<Field>();
        for (int i = 0; i != size; ++i) {
            Field field = fields[i];
            if (!field.isAnnotationPresent(ManyToMany.class) && !field.isAnnotationPresent(OneToMany.class) && !field.isAnnotationPresent(ManyToOne.class) && !field.isAnnotationPresent(OneToOne.class)) continue;
            list.add(field);
        }
        return list.toArray(new Field[list.size()]);
    }

    private RelationPair[] filterFields(RelationPair[] relationPairs, Class<? extends EntityBase> type) {
        int size = relationPairs.length;
        ArrayList<RelationPair> list = new ArrayList<RelationPair>();
        for (int i = 0; i != size; ++i) {
            RelationPair relationPair = relationPairs[i];
            if (this.getTargetEntity(relationPair.relation) != type) continue;
            list.add(relationPair);
        }
        return list.toArray(new RelationPair[list.size()]);
    }

    private static String getTargetName(RelationPair relationPair) {
        String targetName = null;
        Relation annotation = relationPair.relation.getAnnotation(Relation.class);
        if (annotation != null) {
            targetName = annotation.targetName();
        }
        return targetName;
    }

    private RelationInfo getRelationInfo() {
        if (this.relationInfo == null) {
            this.relationInfo = this.generateRelationInfo();
        }
        return this.relationInfo;
    }

    private RelationInfo generateRelationInfo() {
        Field[] allFields = ReflectionUtil.getFields(this.getClass());
        for (int i = 0; i != allFields.length; ++i) {
            try {
                allFields[i] = allFields[i].getDeclaringClass().getDeclaredField(allFields[i].getName());
                continue;
            }
            catch (NoSuchFieldException e) {
                log.error((Object)"This cannot happen, I'm looking for myself!", (Throwable)e);
            }
        }
        Field[] relationFields = EntityBase.removeNonRelations(allFields);
        ArrayList<RelationPair> relationPairs = new ArrayList<RelationPair>();
        for (int i = 0; i != relationFields.length; ++i) {
            Field idField = this.getIdField(relationFields[i], allFields);
            relationPairs.add(new RelationPair(relationFields[i], idField));
        }
        List<Class<?>> duplicateTypes = this.getDuplicateTypes(relationFields);
        return new RelationInfo(relationPairs.toArray(new RelationPair[relationPairs.size()]), duplicateTypes);
    }

    private Field getIdField(Field field, Field[] allFields) {
        if (field.getAnnotation(ManyToOne.class) == null) {
            return null;
        }
        JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
        if (joinColumn == null) {
            return null;
        }
        String columnName = joinColumn.name();
        for (int i = 0; i != allFields.length; ++i) {
            Column column = allFields[i].getAnnotation(Column.class);
            if (column == null || !column.name().equalsIgnoreCase(columnName)) continue;
            return allFields[i];
        }
        return null;
    }

    private List<Class<?>> getDuplicateTypes(Field[] fields) {
        ArrayList types = new ArrayList();
        ArrayList duplicates = new ArrayList();
        for (int fieldIdx = 0; fieldIdx != fields.length; ++fieldIdx) {
            Field field = fields[fieldIdx];
            Class<?> type = this.getTargetEntity(field);
            if (types.contains(type)) {
                if (duplicates.contains(type)) continue;
                duplicates.add(type);
                continue;
            }
            types.add(type);
        }
        return duplicates;
    }

    private boolean isCollection(Field field) {
        return ReflectionUtil.getFieldContent(field, this) instanceof Collection;
    }

    private <T extends EntityBase> Collection<T> valueAsCollection(Field field) {
        return (Collection)ReflectionUtil.getFieldContent(field, this);
    }

    private void setValue(Field field, Object value) {
        ReflectionUtil.setFieldContent(field, this, value);
    }

    private Object getValue(Field field) {
        return ReflectionUtil.getFieldContent(field, this);
    }

    private boolean bidirectional(RelationPair relationPair) {
        Relation relation;
        boolean result = false;
        ManyToMany manyToMany = relationPair.relation.getAnnotation(ManyToMany.class);
        if (!(manyToMany != null && manyToMany.mappedBy().length() == 0 || (relation = relationPair.relation.getAnnotation(Relation.class)) != null && !relation.bidirectional())) {
            result = true;
        }
        return result;
    }

    public <T extends EntityBase> void addRelation(T object, Class<? extends EntityBase> type) {
        this.addRelation(object, type, null);
    }

    public <T extends EntityBase> void addRelation(T object, Class<? extends EntityBase> type, String targetName) {
        if (object == null || type == null) {
            return;
        }
        RelationPair relationPair = this.getRelationPair(type, targetName);
        if (relationPair.relation != null) {
            Field relation;
            if (this.bidirectional(relationPair)) {
                Field foreignId;
                RelationPair foreignRelationPair = object.getRelationPair(this.getClass(), EntityBase.getTargetName(relationPair));
                Field foreignRelation = foreignRelationPair.relation;
                if (foreignRelation != null) {
                    if (super.isCollection(foreignRelation)) {
                        Collection<T> collection = super.valueAsCollection(foreignRelation);
                        if (!collection.contains(this)) {
                            collection.add(this);
                        }
                    } else {
                        super.setValue(foreignRelation, this);
                    }
                }
                if ((foreignId = foreignRelationPair.primaryKey) != null) {
                    super.setValue(foreignId, this.getPrimaryKey());
                }
            }
            if (this.isCollection(relation = relationPair.relation)) {
                Collection<T> collection = this.valueAsCollection(relation);
                if (!collection.contains(object)) {
                    collection.add(object);
                }
            } else {
                this.setValue(relation, object);
            }
            Field id = relationPair.primaryKey;
            if (id != null) {
                this.setValue(id, object.getPrimaryKey());
            }
        }
    }

    public <T extends EntityBase> void addRelations(Collection<T> objects, Class<? extends EntityBase> type) {
        this.addRelations(objects, type, null);
    }

    public <T extends EntityBase> void addRelations(Collection<T> objects, Class<? extends EntityBase> type, String targetName) {
        for (EntityBase object : objects) {
            this.addRelation(object, type, targetName);
        }
    }

    public <T extends EntityBase> void removeRelation(T object, Class<? extends EntityBase> type) {
        this.removeRelation(object, type, null);
    }

    public <T extends EntityBase> void removeRelation(T object, Class<? extends EntityBase> type, String targetName) {
        if (object == null || type == null) {
            return;
        }
        RelationPair relationPair = this.getRelationPair(type, targetName);
        if (relationPair.relation != null) {
            Field relation;
            if (this.bidirectional(relationPair)) {
                Field id;
                RelationPair foreignRelationPair = object.getRelationPair(this.getClass(), EntityBase.getTargetName(relationPair));
                Field foreignRelation = foreignRelationPair.relation;
                if (foreignRelation != null) {
                    if (super.isCollection(foreignRelation)) {
                        super.valueAsCollection(foreignRelation).remove(this);
                    } else {
                        super.setValue(foreignRelation, null);
                    }
                }
                if ((id = foreignRelationPair.primaryKey) != null) {
                    super.setValue(id, null);
                }
            }
            if (this.isCollection(relation = relationPair.relation)) {
                this.valueAsCollection(relation).remove(object);
            } else {
                this.setValue(relation, null);
            }
            Field id = relationPair.primaryKey;
            if (id != null) {
                this.setValue(id, null);
            }
        }
    }

    public <T extends EntityBase> void removeRelations(Collection<T> objects, Class<? extends EntityBase> type) {
        this.removeRelations(objects, type, null);
    }

    public <T extends EntityBase> void removeRelations(Collection<T> objects, Class<? extends EntityBase> type, String targetName) {
        for (EntityBase object : objects) {
            this.removeRelation(object, type, targetName);
        }
    }

    public void clearManyToManyRelations() {
        RelationInfo ri = this.getRelationInfo();
        for (RelationPair rp : ri.relationFields) {
            ManyToMany mtm = rp.relation.getAnnotation(ManyToMany.class);
            if (mtm == null || mtm.mappedBy().length() == 0) continue;
            Relation relation = rp.relation.getAnnotation(Relation.class);
            String targetName = null;
            if (relation != null && (targetName = rp.relation.getName()).length() == 0) {
                targetName = null;
            }
            this.clearRelations(mtm.targetEntity(), targetName);
        }
    }

    public void clearRelations(Class<? extends EntityBase> type) {
        this.clearRelations(type, null);
    }

    public void clearRelations(Class<? extends EntityBase> type, String targetName) {
        if (type == null) {
            return;
        }
        RelationPair relationPair = this.getRelationPair(type, targetName);
        if (relationPair.relation != null) {
            Collection collection;
            Field relation = relationPair.relation;
            boolean isCollection = this.isCollection(relation);
            if (isCollection) {
                collection = this.valueAsCollection(relation);
            } else {
                collection = new ArrayList();
                collection.add((EntityBase)this.getValue(relation));
            }
            for (EntityBase object : collection) {
                Field foreignId;
                RelationPair foreignRelationPair = object.getRelationPair(this.getClass(), EntityBase.getTargetName(relationPair));
                Field foreignRelation = foreignRelationPair.relation;
                if (object.isCollection(foreignRelation)) {
                    object.valueAsCollection(foreignRelation).remove(this);
                } else {
                    object.setValue(foreignRelation, null);
                }
                if ((foreignId = foreignRelationPair.primaryKey) == null) continue;
                object.setValue(foreignId, null);
            }
            if (isCollection) {
                collection.clear();
            } else {
                this.setValue(relation, null);
            }
            Field id = relationPair.primaryKey;
            if (id != null) {
                this.setValue(id, null);
            }
        }
    }

    public <T extends EntityBase> void replaceRelations(Collection<T> newRelations, Class<? extends EntityBase> type) {
        this.replaceRelations(newRelations, type, null);
    }

    public <T extends EntityBase> void replaceRelations(Collection<T> newRelations, Class<? extends EntityBase> type, String targetName) {
        RelationPair relationPair = this.getRelationPair(type, targetName);
        Collection<T> oldRelations = this.valueAsCollection(relationPair.relation);
        ArrayList<T> remove = new ArrayList<T>(oldRelations);
        ArrayList<T> add = new ArrayList<T>(newRelations);
        remove.removeAll(newRelations);
        add.removeAll(oldRelations);
        this.removeRelations(remove, type, targetName);
        this.addRelations(add, type, targetName);
    }

    private static class RelationPair
    implements Serializable {
        private static final long serialVersionUID = -6277624546741670999L;
        public Field relation;
        public Field primaryKey;

        public RelationPair() {
        }

        public RelationPair(Field relation) {
            this.relation = relation;
        }

        public RelationPair(Field relation, Field primaryKey) {
            this(relation);
            this.primaryKey = primaryKey;
        }
    }

    private class RelationInfo
    implements Serializable {
        private static final long serialVersionUID = -3173543334220977776L;
        public RelationPair[] relationFields;
        public Map<Field, String> targetNames;
        public List<Class<?>> duplicateTypes;

        public RelationInfo(RelationPair[] relationFields, List<Class<?>> duplicateTypes) {
            this.relationFields = relationFields;
            this.duplicateTypes = duplicateTypes;
            this.targetNames = new HashMap<Field, String>();
            for (int i = 0; i != relationFields.length; ++i) {
                this.targetNames.put(relationFields[i].relation, EntityBase.getTargetName(relationFields[i]));
            }
        }
    }
}

