/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.jpa.dao;

import de.proveo.util.jpa.dao.BaseDAO;
import de.proveo.util.jpa.dao.Finder;
import de.proveo.util.logging.LogMessage;
import de.proveo.util.logging.LogUtil;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DAOInterceptor
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(DAOInterceptor.class);

    public Object intercept(Object instance, Method method, Object[] arguments, MethodProxy proxy) throws Throwable {
        this.writeLog(method, arguments);
        return this.callMethod(instance, method, arguments, proxy);
    }

    private void writeLog(Method method, Object[] arguments) {
        LogMessage logMessage = method.getAnnotation(LogMessage.class);
        if (logMessage != null) {
            StringBuilder messageBuilder = new StringBuilder();
            String message = logMessage.message();
            if (message.isEmpty() && !logMessage.logMethodParameters()) {
                message = method.getName() + "() called.";
            }
            messageBuilder.append(message);
            if (logMessage.logMethodParameters()) {
                if (!message.isEmpty()) {
                    messageBuilder.append(" - ");
                }
                messageBuilder.append(method.getDeclaringClass().getSimpleName());
                messageBuilder.append(".");
                messageBuilder.append(method.getName());
                messageBuilder.append("(");
                for (int i = 0; i != arguments.length; ++i) {
                    Object argument = arguments[i];
                    if (argument == null) {
                        messageBuilder.append("[null]");
                    } else {
                        messageBuilder.append(argument.toString());
                        messageBuilder.append(" [");
                        messageBuilder.append(argument.getClass().getName());
                        messageBuilder.append("]");
                    }
                    if (i == arguments.length - 1) continue;
                    messageBuilder.append(", ");
                }
                messageBuilder.append(")");
            }
            LogUtil.writeLog(log, messageBuilder.toString(), logMessage.type());
        }
    }

    private Object callMethod(Object instance, Method method, Object[] arguments, MethodProxy proxy) throws Throwable {
        Finder finder = method.getAnnotation(Finder.class);
        Object result = finder == null ? proxy.invokeSuper(instance, arguments) : ((BaseDAO)instance).query(finder, method, arguments);
        return result;
    }
}

