/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.jpa.dao;

import de.proveo.util.jpa.dao.DAOInterceptor;
import de.proveo.util.jpa.dao.Finder;
import de.proveo.util.jpa.dao.Parameter;
import de.proveo.util.jpa.dao.QueryType;
import de.proveo.util.jpa.entity.EntityBase;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;

public abstract class BaseDAO<T extends EntityBase> {
    protected EntityManager entityManager;
    protected Class<?> entityClass;

    public void createEntity(T entity) {
        this.entityManager.persist(entity);
    }

    public T updateEntity(T entity) {
        return (T)((EntityBase)this.entityManager.merge(entity));
    }

    public void removeEntity(T entity) {
        ((EntityBase)entity).clearManyToManyRelations();
        this.entityManager.remove(entity);
    }

    public T findByPrimaryKey(Object primaryKey) {
        return (T)this.findByPrimaryKey(this.entityClass, primaryKey);
    }

    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    private T findByPrimaryKey(Class<T> type, Object primaryKey) {
        this.entityManager.setFlushMode(FlushModeType.COMMIT);
        EntityBase result = (EntityBase)this.entityManager.find(type, primaryKey);
        this.entityManager.setFlushMode(FlushModeType.AUTO);
        return (T)result;
    }

    protected static <I extends BaseDAO<?>> I newInstance(Class<I> daoClass, Class<? extends EntityBase> entityClass, EntityManager entityManager) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(daoClass);
        enhancer.setCallback((Callback)new DAOInterceptor());
        BaseDAO newInstance = (BaseDAO)enhancer.create();
        newInstance.entityManager = entityManager;
        newInstance.entityClass = entityClass;
        return (I)newInstance;
    }

    protected Object query(Finder finder, Method method, Object[] arguments) {
        Object result;
        List<Parameter> parameters = this.getParameterAnnotations(method);
        int size = parameters.size();
        if (size != 0 && size < arguments.length) {
            throw new IllegalArgumentException("@Parameter needed either for ALL method arguments or for NONE in " + method.toString());
        }
        Query query = this.getNamedQuery(finder);
        if (arguments.length != 0) {
            if (size == 0) {
                this.setQueryArguments(query, arguments);
            } else {
                this.setQueryArguments(query, arguments, parameters);
            }
        }
        Class<?> returnType = method.getReturnType();
        QueryType queryType = finder.queryType();
        if (queryType == QueryType.Select) {
            if (returnType == List.class || returnType == Set.class) {
                result = query.getResultList();
            } else {
                try {
                    result = query.getSingleResult();
                }
                catch (NoResultException e) {
                    result = null;
                }
            }
        } else {
            result = query.executeUpdate();
        }
        return result;
    }

    public Object query(String statement, QueryType queryType, boolean singleResult, boolean nativeQuery) {
        Object result;
        Query query;
        Query query2 = query = nativeQuery ? this.entityManager.createNativeQuery(statement) : this.entityManager.createQuery(statement);
        if (queryType == QueryType.Select) {
            if (singleResult) {
                try {
                    result = query.getSingleResult();
                }
                catch (NoResultException e) {
                    result = null;
                }
            } else {
                result = query.getResultList();
            }
        } else {
            result = query.executeUpdate();
        }
        return result;
    }

    private List<Parameter> getParameterAnnotations(Method method) {
        Annotation[][] annotations = method.getParameterAnnotations();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        block0: for (int argIdx = 0; argIdx != annotations.length; ++argIdx) {
            for (int paramIdx = 0; paramIdx != annotations[argIdx].length; ++paramIdx) {
                if (!(annotations[argIdx][paramIdx] instanceof Parameter)) continue;
                parameters.add((Parameter)annotations[argIdx][paramIdx]);
                continue block0;
            }
        }
        return parameters;
    }

    private void setQueryArguments(Query query, Object[] arguments, List<Parameter> parameters) {
        int size = parameters.size();
        if (size != arguments.length) {
            throw new IllegalArgumentException("Number of method arguments and number of @Parameter annotations is not equal.");
        }
        for (int i = 0; i != size; ++i) {
            query.setParameter(parameters.get(i).value(), arguments[i]);
        }
    }

    private void setQueryArguments(Query query, Object[] arguments) {
        for (int i = 0; i != arguments.length; ++i) {
            query.setParameter(i + 1, arguments[i]);
        }
    }

    protected Query getNamedQuery(Finder finder) {
        Query query = this.entityManager.createNamedQuery(finder.value());
        query.setFlushMode(finder.flushMode());
        return query;
    }
}

