/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipFileHelper {
    private static final Log log = LogFactory.getLog(ZipFileHelper.class);

    public static File extract(File zipFile) throws IOException {
        File folder = ZipFileHelper.createTempDir();
        return ZipFileHelper.extract(zipFile, folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(File zipFile, File targetDirectory) throws IOException {
        File folder = targetDirectory;
        ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
        try {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                File newFile = new File(folder, ze.getName());
                if (ze.isDirectory()) {
                    if (!newFile.exists()) {
                        newFile.mkdirs();
                    }
                } else {
                    if (newFile.getParentFile() != null && !newFile.getParentFile().exists()) {
                        newFile.getParentFile().mkdirs();
                    }
                    if (!newFile.exists()) {
                        newFile.createNewFile();
                    }
                    FileOutputStream fos = new FileOutputStream(newFile);
                    fos.getChannel().transferFrom(Channels.newChannel(zis), 0L, Long.MAX_VALUE);
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs into", (Throwable)ex);
            folder.delete();
        }
        finally {
            zis.closeEntry();
            zis.close();
        }
        return folder;
    }

    protected static File createTempDir() throws IOException {
        File folder = File.createTempFile("ZipFileHelper", null);
        folder.delete();
        folder.mkdir();
        return folder;
    }
}

