/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.connection.ssl;

import de.proveo.util.connection.LoginResponse;
import de.proveo.util.connection.ServletConnection;
import de.proveo.util.connection.ServletConnectionException;
import de.proveo.util.connection.ssl.EasySSLProtocolSocketFactory;
import de.proveo.util.date.DateUtil;
import de.proveo.util.properties.PropertyHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import java.util.TimeZone;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AirportMap_SSLTest {
    private static final Log log = LogFactory.getLog(AirportMap_SSLTest.class);
    PropertyHandler properties;

    public AirportMap_SSLTest(String propertyFileName) {
        TimeZone systemTimezone;
        log.debug((Object)"*** Start 'AirportMap_SSLTest' application");
        this.properties = new PropertyHandler(propertyFileName);
        this.properties.setWarning(false);
        Locale systemLocale = Locale.getDefault();
        String languageAndCountry = this.properties.getString("language", systemLocale.getLanguage() + "-" + systemLocale.getCountry());
        String[] lac = languageAndCountry.split("-");
        Locale locale = null;
        locale = lac.length == 2 && lac[0].length() == 2 && lac[1].length() == 2 ? new Locale(lac[0], lac[1]) : (lac.length == 1 && lac[0].length() == 2 ? new Locale(lac[0]) : systemLocale);
        Locale.setDefault(locale);
        TimeZone timezone = systemTimezone = TimeZone.getDefault();
        log.debug((Object)("default time zone of this VM is '" + systemTimezone.getID() + "'"));
        String timezoneID = this.properties.getString("timezone", "");
        if (timezoneID.length() > 0) {
            log.debug((Object)("requested time zone from properties is '" + timezoneID + "'"));
            timezone = TimeZone.getTimeZone(timezoneID);
            if (!timezoneID.equals(timezone.getID())) {
                log.error((Object)("unknown time zone in properties: '" + timezoneID + "' ! time zone now set to '" + timezone.getID() + "'"));
            }
        } else {
            log.debug((Object)"no time zone in properties, use default from VM");
        }
        DateUtil dateUtil = new DateUtil(locale, timezone, systemLocale, systemTimezone);
        String DEFAULT_DATETIME_PATTERN = "dd MMM yy HH:mm:ss";
        String DEFAULT_DURATION_PATTERN = "D 0H:0m:0s";
        dateUtil.setDatetimePattern(this.properties.getString("toolbar.pattern.datetime", "dd MMM yy HH:mm:ss"));
        dateUtil.setDurationPattern(this.properties.getString("toolbar.pattern.duration", "D 0H:0m:0s"));
        this.properties.setProperty("timezone", timezone.getID());
        this.properties.setWarning(true);
    }

    private boolean login_HttpClient() {
        System.out.println("start wwt login using HttpClient...");
        HttpClient client = new HttpClient();
        String url = "https://sats.proveo.de:443/datain/login?username=proveo&password=wwt7sats";
        GetMethod httpget = new GetMethod(url);
        log.error((Object)(" ***\t\t\t\turl was " + url));
        EasySSLProtocolSocketFactory psf = new EasySSLProtocolSocketFactory();
        Protocol easyhttps = new Protocol("https", (ProtocolSocketFactory)psf, 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyhttps);
        ObjectInputStream ois = null;
        try {
            int status = client.executeMethod((HttpMethod)httpget);
            System.out.println(httpget.getStatusLine().toString());
            if (status != 200) {
                System.out.println("status not ok, break");
                return false;
            }
            InputStream is = httpget.getResponseBodyAsStream();
            ois = new ObjectInputStream(is);
        }
        catch (SocketTimeoutException ste) {
            System.out.println(ste.toString());
            System.out.println("URL was " + url);
            return false;
        }
        catch (ConnectException ce) {
            System.out.println(ce.toString());
            System.out.println("URL was " + url);
            return false;
        }
        catch (HttpException e) {
            System.out.println(e.toString());
            System.out.println("URL was " + url);
            return false;
        }
        catch (SSLHandshakeException ssle) {
            System.out.println(ssle.toString());
            System.out.println("URL was " + url);
            return false;
        }
        catch (IOException ioe) {
            System.out.println(ioe.toString());
            String msg = "IOException, Servlet not accessible ? Server not running ?";
            System.out.println(msg);
            System.out.println("URL was " + url);
            return false;
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            String msg = "Exception, Servlet not accessible ? Server not running ?";
            System.out.println(msg);
            System.out.println("URL was " + url);
            return false;
        }
        LoginResponse lr = null;
        try {
            lr = (LoginResponse)ois.readObject();
        }
        catch (IOException ioe) {
            log.error((Object)"login_HttpClient(): Error : ", (Throwable)ioe);
            return false;
        }
        catch (ClassNotFoundException ce) {
            log.error((Object)"login_HttpClient(): Error : ", (Throwable)ce);
            return false;
        }
        if (lr.isAccessPermitted()) {
            System.out.println("SUCCESS: access granted");
        } else {
            System.out.println("INVALID: no access granted");
        }
        try {
            ois.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        httpget.releaseConnection();
        return lr.isAccessPermitted();
    }

    private boolean login_ServletConnection() {
        String sMethodName = "login_ServletConnection(): ";
        String wwtHost = this.properties.getString("wwt.host", "localhost");
        String wwtProtocol = this.properties.getString("wwt.protocol", "http");
        int wwtPort = 80;
        if (wwtProtocol.equals("https")) {
            wwtPort = this.properties.getInt("wwt.port", 443);
        } else if (wwtProtocol.equals("http")) {
            wwtPort = this.properties.getInt("wwt.port", 80);
        } else {
            log.error((Object)(sMethodName + "unknown protocol: wwt.protocol=" + wwtProtocol));
        }
        if (wwtProtocol.equals("https") && (wwtPort == 80 || wwtPort == 8080)) {
            log.error((Object)(sMethodName + "https (SSL) und port " + wwtPort + " passen nicht zusammen ! Fehler in properties ?"));
        }
        log.debug((Object)(sMethodName + "setup servlet connection, port " + wwtPort + ", protocol " + wwtProtocol));
        ServletConnection servletConnection = new ServletConnection(wwtHost, wwtPort, wwtProtocol);
        boolean proxyUse = this.properties.getBoolean("proxy.use", false);
        if (proxyUse) {
            log.debug((Object)(sMethodName + "a proxy should be used..."));
            String proxyHost = this.properties.getString("proxy.host", "");
            int proxyPort = this.properties.getInt("proxy.port", 3128);
            String proxyUser = this.properties.getString("proxy.user", "");
            String proxyPass = this.properties.getString("proxy.pass", "");
            String proxyDomain = this.properties.getString("proxy.domain", "");
            boolean proxyAuthentication = this.properties.getBoolean("proxy.authentication", false);
            if (proxyAuthentication) {
                log.debug((Object)(sMethodName + "...with authentication."));
            } else {
                log.debug((Object)(sMethodName + "...without authentication (transparent proxy)."));
                proxyUser = "";
                proxyPass = "";
                this.properties.setProperty("proxy.user", proxyUser);
                this.properties.setProperty("proxy.pass", proxyPass);
            }
            servletConnection.setupProxy(proxyHost, proxyPort, proxyUser, proxyPass, proxyDomain);
        }
        servletConnection.connect();
        boolean success = false;
        boolean NOT_SUCCESSFUL = false;
        log.debug((Object)(sMethodName + "start wwt login using ServletConnection..."));
        String loginServlet = "datain/login";
        String wwtUser = this.properties.getString("wwt.user", "proveo");
        String wwtPass = this.properties.getString("wwt.pass", "");
        LoginResponse lr = null;
        String parameters = "username=" + wwtUser + "&password=" + wwtPass;
        String url = servletConnection.getSafeUrl(loginServlet, parameters);
        log.debug((Object)("url=" + url + " (excluding password)"));
        try {
            lr = (LoginResponse)servletConnection.readObject(url, wwtPass);
            if (lr == null) {
                log.error((Object)(sMethodName + "No LoginResponse established. Break."));
                return false;
            }
        }
        catch (ServletConnectionException e) {
            int lastState = servletConnection.getLastState();
            String ex = e.getMessage();
            log.error((Object)(sMethodName + "servlet problem '" + ex + "'. HTTP state was '" + lastState + "'. Break."));
            return false;
        }
        if (lr != null) {
            if (lr.isAccessPermitted()) {
                log.debug((Object)(sMethodName + "wwt access granted."));
                success = true;
            } else {
                log.debug((Object)(sMethodName + "wwt access denied."));
                return false;
            }
        }
        return success;
    }

    public static void main(String[] args) {
        String propertyFileName = "";
        if (args.length == 1) {
            propertyFileName = args[0];
        } else {
            System.out.println("usage: AirportMap_SSLTest propertyFile");
            System.exit(-1);
        }
        AirportMap_SSLTest test = new AirportMap_SSLTest(propertyFileName);
        test.login_ServletConnection();
    }
}

