/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.util.airportmap;

import de.proveo.util.concurrent.ExtConcurrentHashMap;
import de.proveo.util.unit.MapClientStampUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MapFilter {
    private static final Log log = LogFactory.getLog(MapFilter.class);
    private final boolean STAMP_PASSED = true;
    private final boolean STAMP_NOT_PASSED = false;
    private Map filter = new HashMap();

    public void setFilter(Map theFilter) {
        this.filter = theFilter;
    }

    public Map getFilter() {
        return this.filter;
    }

    public boolean isFilterSet() {
        return this.filter != null && this.filter.size() >= 1;
    }

    public Map markStamp(Map singleStamp, long now) {
        if (this.isFilterSet()) {
            HashSet<Map<String, Object>> allStampsDummySet = new HashSet<Map<String, Object>>();
            allStampsDummySet.add(singleStamp);
            Map<Long, Map<String, Object>> filteredStamp = this.filterData(allStampsDummySet, now);
            if (filteredStamp.isEmpty()) {
                singleStamp.put("FilterPassed", this.STAMP_NOT_PASSED);
            } else {
                singleStamp.put("FilterPassed", this.STAMP_PASSED);
            }
        } else {
            singleStamp.put("FilterPassed", this.STAMP_PASSED);
        }
        return singleStamp;
    }

    public <T extends Map> T markData(T allStampsMap, long now) {
        String method = "markData(): ";
        if (allStampsMap == null) {
            log.error((Object)(method + "allStampsMap ==null, no stamps to mark"));
            return null;
        }
        if (this.isFilterSet()) {
            this.markStamps(allStampsMap, false);
            Map<Long, Map<String, Object>> filteredStamps = this.filterData(new HashSet<Map<String, Object>>(allStampsMap.values()), now);
            allStampsMap.putAll(filteredStamps);
        } else {
            this.markStamps(allStampsMap, true);
        }
        return allStampsMap;
    }

    public Map<Long, Map<String, Object>> filterData(Set<Map<String, Object>> allStamps, long now) {
        String method = "filterData(): ";
        ExtConcurrentHashMap<Long, Map<String, Object>> filteredStamps = new ExtConcurrentHashMap<Long, Map<String, Object>>();
        if (allStamps == null) {
            log.warn((Object)(method + "allStamps==null, no stamps up to now"));
            return filteredStamps;
        }
        if (!this.isFilterSet()) {
            return this.fastCopy(allStamps);
        }
        List requestedUnitIds = this.getParameters("unitId");
        List requestedUnitKinds = this.getParameters("unitKind");
        List requestedUnitTypes = this.getParameters("unitType");
        Map<String, List> requestedStates = this.getStateModelParameters();
        String requestedIsAlive = (String)this.filter.get("isAlive");
        String requestedIsAliveTimeout = (String)this.filter.get("isAliveTimeout");
        if (now <= 0L) {
            log.error((Object)"now is smaller than or equal to 0, using system current time");
            now = System.currentTimeMillis();
        }
        int stampNo = 0;
        Iterator<Map<String, Object>> it = allStamps.iterator();
        while (it.hasNext()) {
            ++stampNo;
            Map<String, Object> originalStamp = it.next();
            if (originalStamp == null) {
                log.error((Object)(method + "HashMap 'allStamps' contain a stamp=null!, stampNo=" + stampNo + ", allStamps.size=" + allStamps.size()));
                continue;
            }
            ExtConcurrentHashMap<String, Object> filteredStamp = new ExtConcurrentHashMap<String, Object>();
            long unitId = MapClientStampUtil.getUnitId(originalStamp);
            if (unitId == 0L) {
                log.error((Object)(method + "stamp does not contain an unit ID! Don't add this unit!"));
                continue;
            }
            filteredStamp.put("UnitId", unitId);
            String unitName = MapClientStampUtil.getUnitName(originalStamp);
            filteredStamp.put("UnitName", unitName);
            String unitKind = MapClientStampUtil.getUnitSymbolName(originalStamp);
            filteredStamp.put("UnitKind", unitKind);
            String unitType = MapClientStampUtil.getUnitTypeName(originalStamp);
            filteredStamp.put("UnitType", unitType);
            if (!this.matchFilter(requestedUnitIds, Long.toString(unitId)) || !this.matchFilter(requestedUnitKinds, unitKind) || !this.matchFilter(requestedUnitTypes, unitType) || !this.matchFilterKeepalive(requestedIsAlive, requestedIsAliveTimeout, now, originalStamp)) continue;
            boolean add = true;
            for (String state : requestedStates.keySet()) {
                List rtates = requestedStates.get(state);
                if (this.matchFilterState(rtates, originalStamp, filteredStamp, state)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            for (String key : originalStamp.keySet()) {
                Object obj = originalStamp.get(key);
                if (filteredStamp.containsKey(key)) continue;
                filteredStamp.put(key, obj);
            }
            filteredStamp.put("FilterPassed", this.STAMP_PASSED);
            filteredStamps.put(unitId, filteredStamp);
        }
        return filteredStamps;
    }

    private List getParameters(String key) {
        ArrayList<String> list = new ArrayList<String>();
        String par = (String)this.filter.get(key);
        if (par != null) {
            StringTokenizer st = new StringTokenizer(par, ",");
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                list.add(str);
            }
        }
        return list;
    }

    private Map<String, List> getStateModelParameters() {
        HashMap<String, List> ret = new HashMap<String, List>();
        Iterator ite = this.filter.keySet().iterator();
        while (ite.hasNext()) {
            String key = ite.next().toString();
            if (!key.startsWith("StateModel_")) continue;
            ArrayList<String> list = new ArrayList<String>();
            String par = (String)this.filter.get(key);
            if (par != null) {
                StringTokenizer st = new StringTokenizer(par, ",");
                while (st.hasMoreTokens()) {
                    String str = st.nextToken();
                    list.add(str);
                }
            }
            ret.put(key, list);
        }
        return ret;
    }

    private boolean matchFilter(List requestedList, String value) {
        return requestedList.size() <= 0 || requestedList.contains(value);
    }

    private boolean matchFilterState(List reqList, Map stamp, Map fStamp, String stampKey) {
        if (reqList.isEmpty()) {
            return true;
        }
        Object state = null;
        Object oVal = MapClientStampUtil.getValue(stamp, stampKey);
        if (oVal != null && oVal instanceof Map) {
            Map stateMap = (Map)oVal;
            state = stateMap.get("StateId");
        }
        if (state != null && reqList.contains(state.toString())) {
            fStamp.put(stampKey, oVal);
            return true;
        }
        return false;
    }

    private boolean matchFilterKeepalive(String requestedIsAlive, String requestedIsAliveTimeout, long now, Map stamp) {
        if (requestedIsAlive == null || requestedIsAlive != null && requestedIsAlive.length() == 0) {
            return true;
        }
        if (requestedIsAlive.equals("true,false") || requestedIsAlive.equals("false,true")) {
            return true;
        }
        long requestedTimeout = Long.parseLong(requestedIsAliveTimeout);
        boolean timeoutReached = MapClientStampUtil.isKeepaliveTimeoutReached(stamp, requestedTimeout, now);
        boolean filterAlive = Boolean.parseBoolean(requestedIsAlive);
        if (!timeoutReached && filterAlive) {
            return true;
        }
        return timeoutReached && !filterAlive;
    }

    private Map<Long, Map<String, Object>> fastCopy(Set<Map<String, Object>> allStamps) {
        String method = "fastCopy(): ";
        ExtConcurrentHashMap<Long, Map<String, Object>> copiedStamps = new ExtConcurrentHashMap<Long, Map<String, Object>>();
        int stampNo = 0;
        Iterator<Map<String, Object>> it = allStamps.iterator();
        while (it.hasNext()) {
            ++stampNo;
            Map<String, Object> singleStamp = it.next();
            if (singleStamp == null) {
                log.error((Object)(method + "Set 'allStamps' contain a stamp=null!, stampNo=" + stampNo + ", allStamps.size=" + allStamps.size()));
                continue;
            }
            long unitId = MapClientStampUtil.getUnitId(singleStamp);
            if (unitId == 0L) {
                log.error((Object)(method + " singleStamp does not contain an unit ID!"));
                continue;
            }
            copiedStamps.put(unitId, singleStamp);
        }
        return copiedStamps;
    }

    private void markStamps(Map stamps, boolean marker) {
        for (Map singleStamp : stamps.values()) {
            singleStamp.put("FilterPassed", marker);
        }
    }
}

