/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LayersBridge
extends KeymapManager {
    private static final String EXT_REMOVED = "removed";
    private static final Logger LOG = Logger.getLogger(LayersBridge.class.getName());
    static final String KEYMAPS_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String LAYERS_BRIDGE = "LayersBridge";
    private Map<GlobalAction, DataObject> actionToDataObject = new HashMap<GlobalAction, DataObject>();
    private Map<String, Set<ShortcutAction>> categoryToActions;
    private Set<GlobalAction> actions = new HashSet<GlobalAction>();
    private List<String> keymapNames;
    private Map<String, String> keymapDisplayNames;
    private Map<String, Map<ShortcutAction, Set<String>>> keymaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private volatile Map<ShortcutAction, Set<String>> baseKeyMap;
    private Map<String, Map<ShortcutAction, Set<String>>> keymapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private static final GlobalAction REMOVED = new GlobalAction(null, null, "<removed>"){
        {
            this.name = "";
        }
    };
    private static final String OPENIDE_DELEGATE_ACTION = "org.openide.awt.GeneralAction$DelegateAction";
    private static Field KEY_FIELD;

    public LayersBridge() {
        super(LAYERS_BRIDGE);
    }

    @Override
    public synchronized Map<String, Set<ShortcutAction>> getActions() {
        if (this.categoryToActions == null) {
            this.categoryToActions = new HashMap<String, Set<ShortcutAction>>();
            this.initActions("Actions", null);
            this.categoryToActions.remove("Hidden");
            this.categoryToActions = Collections.unmodifiableMap(this.categoryToActions);
        }
        return this.categoryToActions;
    }

    private void initActions(String folder, String category) {
        FileObject fo = FileUtil.getConfigFile((String)folder);
        if (fo == null) {
            return;
        }
        DataFolder root = DataFolder.findFolder((FileObject)fo);
        Enumeration en = root.children();
        while (en.hasMoreElements()) {
            DataObject dataObject = (DataObject)en.nextElement();
            if (!(dataObject instanceof DataFolder)) continue;
            this.initActions((DataFolder)dataObject, null, category);
        }
    }

    private void initActions(DataFolder folder, String folderName, String category) {
        String name = folder.getName();
        if (category != null) {
            name = category;
        } else {
            String bundleName = (String)folder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
            if (bundleName != null) {
                try {
                    name = NbBundle.getBundle((String)bundleName).getString(folder.getPrimaryFile().getPath());
                }
                catch (MissingResourceException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (folderName != null) {
                name = folderName + '/' + name;
            }
        }
        Enumeration en = folder.children();
        while (en.hasMoreElements()) {
            DataObject dataObject = (DataObject)en.nextElement();
            if (dataObject instanceof DataFolder) {
                this.initActions((DataFolder)dataObject, name, category);
                continue;
            }
            GlobalAction action = this.createAction(dataObject, name);
            if (this.actions.contains(action) || action == null) continue;
            this.actions.add(action);
            Set<ShortcutAction> a = this.categoryToActions.get(name);
            if (a == null) {
                a = new HashSet<ShortcutAction>();
                this.categoryToActions.put(name, a);
            }
            a.add(action);
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            this.actionToDataObject.put(action, dataObject);
        }
    }

    private void refreshKeymapNames() {
        DataFolder root = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
        Enumeration en = root.children(false);
        this.keymapNames = new ArrayList<String>();
        this.keymapDisplayNames = new HashMap<String, String>();
        while (en.hasMoreElements()) {
            String displayName;
            FileObject f = ((DataObject)en.nextElement()).getPrimaryFile();
            if (!f.isFolder()) continue;
            String name = f.getNameExt();
            try {
                displayName = f.getFileSystem().getStatus().annotateName(name, Collections.singleton(f));
            }
            catch (FileStateInvalidException fsie) {
                displayName = name;
            }
            this.keymapNames.add(name);
            this.keymapDisplayNames.put(name, displayName);
        }
        if (this.keymapNames.isEmpty()) {
            this.keymapNames.add("NetBeans");
        }
    }

    @Override
    public List<String> getProfiles() {
        if (this.keymapNames == null) {
            this.refreshKeymapNames();
        }
        return Collections.unmodifiableList(this.keymapNames);
    }

    @Override
    public String getProfileDisplayName(String profileName) {
        String displayName = this.keymapDisplayNames.get(profileName);
        return displayName == null ? profileName : displayName;
    }

    @Override
    public Map<ShortcutAction, Set<String>> getKeymap(String profile) {
        if (!this.keymaps.containsKey(profile)) {
            DataFolder root = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> m = this.readKeymap(root);
            root = LayersBridge.getRootFolder(KEYMAPS_FOLDER, profile);
            this.overrideWithKeyMap(m, this.readKeymap(root), profile);
            m.remove(REMOVED);
            this.keymaps.put(profile, m);
        }
        return Collections.unmodifiableMap(this.keymaps.get(profile));
    }

    private Map<ShortcutAction, Set<String>> getBaseKeyMap() {
        if (this.baseKeyMap == null) {
            DataFolder root = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> m = this.readKeymap(root);
            this.baseKeyMap = m;
        }
        return this.baseKeyMap;
    }

    private Map<ShortcutAction, Set<String>> overrideWithKeyMap(Map<ShortcutAction, Set<String>> base, Map<ShortcutAction, Set<String>> keyMap, String profile) {
        HashSet overrideKeyStrokes = new HashSet();
        Map<String, ShortcutAction> shortcuts = null;
        for (ShortcutAction a : keyMap.keySet()) {
            overrideKeyStrokes.addAll(keyMap.get(a));
        }
        Iterator<Map.Entry<ShortcutAction, Set<String>>> it = base.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ShortcutAction, Set<String>> en = it.next();
            Set<String> keys = en.getValue();
            if (LOG.isLoggable(Level.FINER)) {
                for (String s : keys) {
                    ShortcutAction sa;
                    if (!overrideKeyStrokes.contains(s)) continue;
                    if (shortcuts == null) {
                        shortcuts = LayersBridge.shortcutToAction(keyMap);
                    }
                    if ((sa = shortcuts.get(s)).getId().equals(en.getKey().getId())) continue;
                    LOG.finer("[" + profile + "] change keybinding " + s + " from " + en.getKey().getId() + " to " + sa.getId());
                }
            }
            keys.removeAll(overrideKeyStrokes);
            if (!keys.isEmpty()) continue;
            it.remove();
        }
        base.putAll(keyMap);
        return base;
    }

    @Override
    public synchronized Map<ShortcutAction, Set<String>> getDefaultKeymap(String profile) {
        if (!this.keymapDefaults.containsKey(profile)) {
            DataFolder root = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            System.err.println(Arrays.asList(root.getChildren()));
            Map<ShortcutAction, Set<String>> m = this.readKeymap(root);
            root = LayersBridge.getRootFolder(KEYMAPS_FOLDER, profile);
            this.overrideWithKeyMap(m, this.readKeymap(root), profile);
            m.remove(REMOVED);
            this.keymapDefaults.put(profile, m);
        }
        return Collections.unmodifiableMap(this.keymapDefaults.get(profile));
    }

    DataObject getDataObject(Object action) {
        return this.actionToDataObject.get(action);
    }

    private Map<ShortcutAction, Set<String>> readKeymap(DataFolder root) {
        LOG.log(Level.FINEST, "Reading keymap from: {0}", root);
        HashMap<ShortcutAction, Set<String>> keymap = new HashMap<ShortcutAction, Set<String>>();
        if (root == null) {
            return keymap;
        }
        Enumeration en = root.children(false);
        while (en.hasMoreElements()) {
            GlobalAction action;
            DataObject dataObject = (DataObject)en.nextElement();
            if (dataObject instanceof DataFolder || (action = this.createAction(dataObject, null)) == null) continue;
            String shortcut = dataObject.getPrimaryFile().getName();
            LOG.log(Level.FINEST, "Action {0}: {1}, by {2}", new Object[]{action.getDisplayName(), shortcut, dataObject.getPrimaryFile().getPath()});
            HashSet<String> s = (HashSet<String>)keymap.get(action);
            if (s == null) {
                s = new HashSet<String>();
                keymap.put(action, s);
            }
            s.add(shortcut);
        }
        return keymap;
    }

    @Override
    public void deleteProfile(String profile) {
        FileObject root = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
        if (root == null) {
            return;
        }
        if ((root = root.getFileObject(profile)) == null) {
            return;
        }
        try {
            root.delete();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    @Override
    public void saveKeymap(String profile, Map<ShortcutAction, Set<String>> actionToShortcuts) {
        this.keymaps.remove(profile);
        this.keymapDefaults.remove(profile);
        DataFolder defaultFolder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
        DataFolder folder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, profile);
        if (folder == null) {
            folder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
            try {
                folder = DataFolder.create((DataFolder)folder, (String)profile);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return;
            }
        }
        this.saveKeymap(defaultFolder, folder, actionToShortcuts);
    }

    private void saveKeymap(DataFolder defaultMap, DataFolder folder, Map<ShortcutAction, Set<String>> actionToShortcuts) {
        GlobalAction action;
        DataObject dataObject;
        LOG.log(Level.FINEST, "Saving keymap to: {0}", folder.getPrimaryFile().getPath());
        this.getActions();
        Map<String, ShortcutAction> shortcutToAction = LayersBridge.shortcutToAction(actionToShortcuts);
        HashSet<String> definedShortcuts = new HashSet<String>(shortcutToAction.keySet());
        FileObject targetDir = folder.getPrimaryFile();
        Enumeration en = folder.children();
        while (en.hasMoreElements()) {
            dataObject = (DataObject)en.nextElement();
            if (dataObject.getPrimaryFile().getExt().equals(EXT_REMOVED)) continue;
            GlobalAction a1 = (GlobalAction)shortcutToAction.get(dataObject.getName());
            if (a1 != null) {
                action = this.createAction(dataObject, null);
                if (action == null) continue;
                if (action.equals(a1)) {
                    LOG.log(Level.FINEST, "Found same binding: {0} -> {1}", new Object[]{dataObject.getName(), action.getId()});
                    shortcutToAction.remove(dataObject.getName());
                    continue;
                }
            }
            try {
                LOG.log(Level.FINEST, "Removing obsolete binding: {0}", dataObject.getName());
                dataObject.delete();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        en = defaultMap.children();
        while (en.hasMoreElements()) {
            dataObject = (DataObject)en.nextElement();
            GlobalAction ga = (GlobalAction)shortcutToAction.get(dataObject.getName());
            if (ga == null || !ga.equals(action = this.createAction(dataObject, null))) continue;
            LOG.log(Level.FINEST, "Leaving default shortcut: {0}", dataObject.getName());
            shortcutToAction.remove(dataObject.getName());
        }
        for (String shortcut : shortcutToAction.keySet()) {
            action = (GlobalAction)shortcutToAction.get(shortcut);
            DataObject dataObject2 = this.actionToDataObject.get(action);
            if (dataObject2 == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("No original DataObject specified! Not possible to create shadow1. " + action);
                continue;
            }
            try {
                DataShadow.create((DataFolder)folder, (String)shortcut, (DataObject)dataObject2);
                FileObject f = targetDir.getFileObject(shortcut, EXT_REMOVED);
                if (f == null) continue;
                f.delete();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (defaultMap != null) {
            en = defaultMap.children();
            while (en.hasMoreElements()) {
                DataObject dataObject3 = (DataObject)en.nextElement();
                if (definedShortcuts.contains(dataObject3.getName())) continue;
                try {
                    FileObject pf = dataObject3.getPrimaryFile();
                    if (targetDir.getFileObject(pf.getName(), EXT_REMOVED) != null) continue;
                    LOG.log(Level.FINEST, "Masking out binding: {0}", pf.getName());
                    folder.getPrimaryFile().createData(pf.getName(), EXT_REMOVED);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static DataFolder getRootFolder(String name1, String name2) {
        FileObject root = FileUtil.getConfigRoot();
        FileObject fo1 = root.getFileObject(name1);
        try {
            if (fo1 == null) {
                fo1 = root.createFolder(name1);
            }
            if (fo1 == null) {
                return null;
            }
            if (name2 == null) {
                return DataFolder.findFolder((FileObject)fo1);
            }
            FileObject fo2 = fo1.getFileObject(name2);
            if (fo2 == null) {
                fo2 = fo1.createFolder(name2);
            }
            if (fo2 == null) {
                return null;
            }
            return DataFolder.findFolder((FileObject)fo2);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    private GlobalAction createAction(DataObject dataObject, String prefix) {
        InstanceCookie ic = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        if (ic == null) {
            FileObject pf = dataObject.getPrimaryFile();
            if (!EXT_REMOVED.equals(pf.getExt())) {
                LOG.log(Level.WARNING, "Invalid shortcut: {0}", dataObject);
            }
            if (FileUtil.findBrother((FileObject)pf, (String)"shadow") != null) {
                return null;
            }
            return REMOVED;
        }
        try {
            Object action = ic.instanceCreate();
            if (action == null) {
                return null;
            }
            if (!(action instanceof Action)) {
                return null;
            }
            return LayersBridge.createAction((Action)action, prefix, dataObject.getPrimaryFile().getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static GlobalAction createAction(Action a, String prefix, String name) {
        String id = name;
        try {
            if (a.getClass().getName().equals(OPENIDE_DELEGATE_ACTION)) {
                String key;
                if (KEY_FIELD == null) {
                    Class<?> c = a.getClass();
                    KEY_FIELD = c.getSuperclass().getDeclaredField("key");
                    KEY_FIELD.setAccessible(true);
                }
                if ((key = (String)KEY_FIELD.get(a)) != null) {
                    id = key;
                }
            }
        }
        catch (NoSuchFieldException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return new GlobalAction(a, prefix, id);
    }

    static Map<String, ShortcutAction> shortcutToAction(Map<ShortcutAction, Set<String>> actionToShortcuts) {
        HashMap<String, ShortcutAction> shortcutToAction = new HashMap<String, ShortcutAction>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : actionToShortcuts.entrySet()) {
            ShortcutAction action = entry.getKey();
            Set<String> shortcuts = entry.getValue();
            ShortcutAction shortcutAction = action = action != null ? action.getKeymapManagerInstance(LAYERS_BRIDGE) : null;
            if (!(action instanceof GlobalAction)) continue;
            for (String multiShortcut : shortcuts) {
                shortcutToAction.put(multiShortcut, action);
            }
        }
        return shortcutToAction;
    }

    @Override
    public void refreshActions() {
        this.refreshKeymapNames();
    }

    @Override
    public String getCurrentProfile() {
        return null;
    }

    @Override
    public void setCurrentProfile(String profileName) {
    }

    @Override
    public boolean isCustomProfile(String profileName) {
        return false;
    }

    static String getOrigActionClass(ShortcutAction sa) {
        if (!(sa instanceof GlobalAction)) {
            return null;
        }
        return ((GlobalAction)sa).action.getClass().getName();
    }

    private static class GlobalAction
    implements ShortcutAction {
        private Action action;
        String name;
        private String id;

        private GlobalAction(Action a, String prefix, String n) {
            this.action = a;
            this.id = n;
        }

        @Override
        public String getDisplayName() {
            if (this.name == null) {
                this.name = (String)this.action.getValue("Name");
                if (this.name == null) {
                    this.name = "";
                }
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        @Override
        public String getId() {
            if (this.id == null) {
                this.id = this.action.getClass().getName();
            }
            return this.id;
        }

        @Override
        public String getDelegatingActionId() {
            return null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GlobalAction)) {
                return false;
            }
            return ((GlobalAction)o).action == this.action || ((GlobalAction)o).action.equals(this.action);
        }

        public int hashCode() {
            return this.action == null ? 111 : this.action.hashCode();
        }

        public String toString() {
            return "GlobalAction[" + this.getDisplayName() + ":" + this.id + "]";
        }

        @Override
        public ShortcutAction getKeymapManagerInstance(String keymapManagerName) {
            if (LayersBridge.LAYERS_BRIDGE.equals(keymapManagerName)) {
                return this;
            }
            return null;
        }
    }
}

