/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.domain.values.datasync;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.PropertyKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@PropertyKey(name="resource")
public class DatasyncResourceValue
implements Serializable {
    private static final long serialVersionUID = -1248879288742742351L;
    @PropertyKey(name="id")
    private long resourceId = 0L;
    @PropertyKey(name="name")
    private String resourceName = null;
    @PropertyKey(name="validfrom")
    private long validFrom = 0L;
    @PropertyKey(name="validtill")
    private long validTill = 0L;
    private boolean hasMetaInfo = false;
    private byte[] resource = null;
    @PropertyKey(name="checksum")
    private String checksum = null;
    private boolean contentPresent = false;
    private List<DatasyncMetainfoValue> metainfos = null;

    public long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public byte[] getResource() {
        return this.resource;
    }

    public void setResource(byte[] resource) {
        this.contentPresent = true;
        this.resource = resource;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public long getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(long validFrom) {
        this.validFrom = validFrom;
    }

    public long getValidTill() {
        return this.validTill;
    }

    public void setValidTill(long validTill) {
        this.validTill = validTill;
    }

    public boolean isContentPresent() {
        return this.contentPresent;
    }

    public void setContentPresent(boolean contentPresent) {
        this.contentPresent = contentPresent;
    }

    public List<DatasyncMetainfoValue> getMetainfos() {
        return this.metainfos;
    }

    public void setMetainfos(List<DatasyncMetainfoValue> metainfos) {
        this.metainfos = metainfos;
        if (metainfos != null && metainfos.size() > 0) {
            this.hasMetaInfo = true;
        }
    }

    public void addMetaInfoValue(DatasyncMetainfoValue value) {
        if (value != null) {
            if (this.metainfos != null) {
                this.metainfos.add(value);
                this.hasMetaInfo = true;
            } else {
                this.metainfos = new ArrayList<DatasyncMetainfoValue>();
                this.metainfos.add(value);
                this.hasMetaInfo = true;
            }
        }
    }

    public boolean isHasMetaInfo() {
        return this.hasMetaInfo;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DatasyncResourceValue [checksum=");
        builder.append(this.checksum);
        builder.append(", ResourceId=");
        builder.append(this.resourceId);
        builder.append(", hasMetaInfo=");
        builder.append(this.hasMetaInfo);
        builder.append(", metainfos=");
        builder.append(this.metainfos);
        builder.append(", resource=");
        if (this.resource != null) {
            builder.append(this.resource.length);
        } else {
            builder.append(0);
        }
        builder.append(" byte length");
        builder.append(", resourceName=");
        builder.append(this.resourceName);
        builder.append(", validFrom=");
        builder.append(this.validFrom);
        builder.append(", validTill=");
        builder.append(this.validTill);
        builder.append("]");
        return builder.toString();
    }
}

