/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.domain.values.datasync;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncStatusValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLMetainfoValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLResourceValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLStatusValue;
import de.proveo.domain.values.datasync.xml.DatasyncXMLTaskValue;
import java.util.ArrayList;
import java.util.List;

public class DatasyncConverter {
    public static DatasyncMetainfoValue convertXMLDatasyncMetaInfoValue(DatasyncXMLMetainfoValue xmlValue) {
        DatasyncMetainfoValue value = new DatasyncMetainfoValue();
        value.setKey(xmlValue.getKey());
        value.setValue(xmlValue.getValue());
        return value;
    }

    public static DatasyncResourceValue convertXMLDatasyncResourceValue(DatasyncXMLResourceValue xmlValue) {
        DatasyncResourceValue value = new DatasyncResourceValue();
        value.setChecksum(xmlValue.getChecksum());
        List<DatasyncXMLMetainfoValue> xmlMetaInfos = xmlValue.getMetainfos();
        if (xmlMetaInfos != null) {
            ArrayList<DatasyncMetainfoValue> metaInfos = new ArrayList<DatasyncMetainfoValue>();
            for (DatasyncXMLMetainfoValue info : xmlMetaInfos) {
                metaInfos.add(DatasyncConverter.convertXMLDatasyncMetaInfoValue(info));
            }
            value.setMetainfos(metaInfos);
        }
        value.setResource(xmlValue.getResource());
        value.setResourceId(xmlValue.getResourceId());
        value.setResourceName(xmlValue.getResourceName());
        value.setValidFrom(xmlValue.getValidFrom());
        value.setValidTill(xmlValue.getValidTill());
        return value;
    }

    public static DatasyncStatusValue convertXMLDatasyncStatusValue(DatasyncXMLStatusValue xmlValue) {
        DatasyncStatusValue value = new DatasyncStatusValue();
        xmlValue.setClientId(xmlValue.getClientId());
        xmlValue.setErrorMessage(xmlValue.getErrorMessage());
        xmlValue.setFinishedTime(xmlValue.getFinishedTime());
        xmlValue.setIdentifier(xmlValue.getIdentifier());
        xmlValue.setLastRetryTime(xmlValue.getLastRetryTime());
        xmlValue.setRemark(xmlValue.getRemark());
        xmlValue.setRetryCount(xmlValue.getRetryCount());
        xmlValue.setSerialNumber(xmlValue.getSerialNumber());
        xmlValue.setStartedTime(xmlValue.getStartedTime());
        xmlValue.setStatus(xmlValue.getStatus());
        xmlValue.setTaskId(xmlValue.getTaskId());
        xmlValue.setTaskInfo(xmlValue.getTaskInfo());
        xmlValue.setValidFrom(xmlValue.getValidFrom());
        xmlValue.setValidTill(xmlValue.getValidTill());
        return value;
    }

    public static DatasyncTaskValue convertXMLDatasyncTaskValue(DatasyncXMLTaskValue xmlValue) {
        List<DatasyncXMLResourceValue> xmlResources;
        DatasyncTaskValue value = new DatasyncTaskValue();
        value.setClientId(xmlValue.getClientId());
        value.setClientSerialNumber(xmlValue.getClientSerialNumber());
        value.setIdentifier(xmlValue.getIdentifier());
        value.setMaxRetry(xmlValue.getMaxRetry());
        List<DatasyncXMLMetainfoValue> xmlMetaInfos = xmlValue.getMetainfos();
        if (xmlMetaInfos != null) {
            ArrayList<DatasyncMetainfoValue> metaInfos = new ArrayList<DatasyncMetainfoValue>();
            for (DatasyncXMLMetainfoValue info : xmlMetaInfos) {
                metaInfos.add(DatasyncConverter.convertXMLDatasyncMetaInfoValue(info));
            }
            value.setMetainfos(metaInfos);
        }
        if ((xmlResources = xmlValue.getResources()) != null) {
            ArrayList<DatasyncResourceValue> resources = new ArrayList<DatasyncResourceValue>();
            for (DatasyncXMLResourceValue resource : xmlResources) {
                resources.add(DatasyncConverter.convertXMLDatasyncResourceValue(resource));
            }
            value.setResources(resources);
        }
        value.setTaskId(xmlValue.getTaskId());
        value.setTaskInfo(xmlValue.getTaskInfo());
        value.setValidFrom(xmlValue.getValidFrom());
        value.setValidTill(xmlValue.getValidTill());
        return value;
    }
}

