/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.EmptyTestCaseWizardIterator;
import org.netbeans.modules.junit.wizards.SimpleTestStepLocation;
import org.netbeans.modules.junit.wizards.StepProblemMessage;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class SimpleTestCaseWizardIterator
implements TemplateWizard.Iterator {
    private static SimpleTestCaseWizardIterator instance;
    private TemplateWizard wizard;
    private static final int INDEX_CHOOSE_CLASS = 2;
    private final String nameChooseClass = NbBundle.getMessage(SimpleTestCaseWizardIterator.class, (String)"LBL_panel_ChooseClass");
    private int current;
    private List<ChangeListener> changeListeners;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel<WizardDescriptor> classChooserPanel;

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(2);
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(l);
            if (this.changeListeners.isEmpty()) {
                this.changeListeners = null;
            }
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            Iterator<ChangeListener> i = this.changeListeners.iterator();
            while (i.hasNext()) {
                i.next().stateChanged(e);
            }
        }
    }

    public boolean hasPrevious() {
        return this.current > 2;
    }

    public boolean hasNext() {
        return this.current < 2;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.current;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.current;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        switch (this.current) {
            case 2: {
                return this.getClassChooserPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel<WizardDescriptor> getClassChooserPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (this.classChooserPanel == null || project != this.lastSelectedProject) {
            SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test");
            Utils utils = new Utils(project);
            if (utils.getSourcesToTestsMap(true).isEmpty()) {
                this.classChooserPanel = new StepProblemMessage(project, NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
            } else {
                if (this.classChooserPanel == null) {
                    this.classChooserPanel = new SimpleTestStepLocation();
                }
                ((SimpleTestStepLocation)this.classChooserPanel).setUp(utils);
            }
        }
        this.lastSelectedProject = project;
        return this.classChooserPanel;
    }

    public String name() {
        switch (this.current) {
            case 2: {
                return this.nameChooseClass;
            }
        }
        throw new AssertionError(this.current);
    }

    private void loadSettings(TemplateWizard wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        wizard.putProperty("Public", (Object)settings.isMembersPublic());
        wizard.putProperty("Protected", (Object)settings.isMembersProtected());
        wizard.putProperty("Package", (Object)settings.isMembersPackage());
        wizard.putProperty("SetUp", (Object)settings.isGenerateSetUp());
        wizard.putProperty("TearDown", (Object)settings.isGenerateTearDown());
        wizard.putProperty("BeforeClass", (Object)settings.isGenerateClassSetUp());
        wizard.putProperty("AfterClass", (Object)settings.isGenerateClassTearDown());
        wizard.putProperty("Content", (Object)settings.isBodyContent());
        wizard.putProperty("JavaDoc", (Object)settings.isJavaDoc());
        wizard.putProperty("Comments", (Object)settings.isBodyComments());
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(SimpleTestStepLocation.class, (String)"LBL_simpleTestWizard_stepName"));
    }

    private void saveSettings(TemplateWizard wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        settings.setMembersPublic(Boolean.TRUE.equals(wizard.getProperty("Public")));
        settings.setMembersProtected(Boolean.TRUE.equals(wizard.getProperty("Protected")));
        settings.setMembersPackage(Boolean.TRUE.equals(wizard.getProperty("Package")));
        settings.setGenerateSetUp(Boolean.TRUE.equals(wizard.getProperty("SetUp")));
        settings.setGenerateTearDown(Boolean.TRUE.equals(wizard.getProperty("TearDown")));
        settings.setGenerateClassSetUp(Boolean.TRUE.equals(wizard.getProperty("BeforeClass")));
        settings.setGenerateClassTearDown(Boolean.TRUE.equals(wizard.getProperty("AfterClass")));
        settings.setBodyContent(Boolean.TRUE.equals(wizard.getProperty("Content")));
        settings.setJavaDoc(Boolean.TRUE.equals(wizard.getProperty("JavaDoc")));
        settings.setBodyComments(Boolean.TRUE.equals(wizard.getProperty("Comments")));
    }

    public void initialize(TemplateWizard wiz) {
        this.wizard = wiz;
        this.current = 2;
        this.loadSettings(wiz);
        String[] panelNames = new String[]{NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_chooseFileType"), NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"LBL_panel_ChooseClass")};
        ((JComponent)this.getClassChooserPanel().getComponent()).putClientProperty("WizardPanel_contentData", panelNames);
        ((JComponent)this.getClassChooserPanel().getComponent()).putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public void uninitialize(TemplateWizard wiz) {
        if (this.classChooserPanel != null && !(this.classChooserPanel instanceof StepProblemMessage)) {
            assert (this.classChooserPanel instanceof SimpleTestStepLocation);
            ((SimpleTestStepLocation)this.classChooserPanel).cleanUp();
        }
        this.classChooserPanel = null;
        this.changeListeners = null;
        this.wizard = null;
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        this.saveSettings(wiz);
        FileObject classToTest = (FileObject)this.wizard.getProperty("classToTest");
        FileObject testRootFolder = (FileObject)this.wizard.getProperty("testRootFolder");
        Map params = TestUtil.getSettingsMap((boolean)false);
        JUnitPlugin plugin = TestUtil.getPluginForProject(Templates.getProject((WizardDescriptor)this.wizard));
        if (!JUnitPluginTrampoline.DEFAULT.createTestActionCalled(plugin, new FileObject[]{classToTest})) {
            return null;
        }
        FileObject[] testFileObjects = JUnitPluginTrampoline.DEFAULT.createTests(plugin, new FileObject[]{classToTest}, testRootFolder, params);
        if (testFileObjects == null) {
            throw new IOException();
        }
        HashSet<DataObject> dataObjects = new HashSet<DataObject>((int)((float)testFileObjects.length * 1.5f));
        for (FileObject testFile : testFileObjects) {
            try {
                dataObjects.add(DataObject.find((FileObject)testFile));
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        if (dataObjects.isEmpty()) {
            throw new IOException();
        }
        return dataObjects;
    }

    public static SimpleTestCaseWizardIterator singleton() {
        if (instance == null) {
            instance = new SimpleTestCaseWizardIterator();
        }
        return instance;
    }
}

