/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.junit.output.JUnitTestSuite;
import org.netbeans.modules.junit.output.JUnitTestcase;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

final class XmlOutputParser
extends DefaultHandler {
    private static final int STATE_OUT_OF_SCOPE = 1;
    private static final int STATE_TESTSUITE = 2;
    private static final int STATE_PROPERTIES = 3;
    private static final int STATE_PROPERTY = 4;
    private static final int STATE_TESTCASE = 8;
    private static final int STATE_FAILURE = 12;
    private static final int STATE_ERROR = 13;
    private static final int STATE_OUTPUT_STD = 16;
    private static final int STATE_OUTPUT_ERR = 17;
    private int state = 1;
    int unknownElemNestLevel = 0;
    private final XMLReader xmlReader;
    private JUnitTestSuite suite;
    private Testcase testcase;
    private Trouble trouble;
    private StringBuffer charactersBuf;
    private final RegexpUtils regexp;
    private TestSession testSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JUnitTestSuite parseXmlOutput(Reader reader, TestSession session) throws SAXException, IOException {
        XmlOutputParser parser = new XmlOutputParser(session);
        try {
            parser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            String message = ex.getMessage();
            int severity = 1;
            if (message != null && ErrorManager.getDefault().isLoggable(severity)) {
                ErrorManager.getDefault().log(severity, "Exception while parsing XML output from JUnit: " + message);
            }
            throw ex;
        }
        catch (IOException ex) {
            assert (false);
        }
        finally {
            reader.close();
        }
        return parser.suite;
    }

    private XmlOutputParser(TestSession session) throws SAXException {
        this.testSession = session;
        this.xmlReader = XMLUtil.createXMLReader();
        this.xmlReader.setContentHandler(this);
        this.regexp = RegexpUtils.getInstance();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        switch (this.state) {
            case 3: {
                if (qName.equals("property")) {
                    this.state = 4;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 2: {
                if (qName.equals("testcase")) {
                    this.testcase = this.createTestcaseReport(attrs.getValue("classname"), attrs.getValue("name"), attrs.getValue("time"));
                    this.state = 8;
                    break;
                }
                if (qName.equals("system-out")) {
                    this.state = 16;
                    break;
                }
                if (qName.equals("system-err")) {
                    this.state = 17;
                    break;
                }
                if (qName.equals("properties")) {
                    this.state = 3;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 8: {
                if (qName.equals("failure")) {
                    this.state = 12;
                } else if (qName.equals("error")) {
                    this.state = 13;
                } else {
                    this.startUnknownElem();
                }
                if (this.state < 0) break;
                assert (this.testcase != null);
                this.trouble = new Trouble(this.state == 13);
                String attrValue = attrs.getValue("message");
                if (attrValue != null) {
                    this.addStackTraceLine(this.trouble, attrValue, false);
                }
                if ((attrValue = attrs.getValue("type")) == null) break;
                this.addStackTraceLine(this.trouble, attrValue, false);
                break;
            }
            case 1: {
                if (qName.equals("testsuite")) {
                    this.suite = this.createSuite(attrs.getValue("name"), attrs.getValue("tests"), attrs.getValue("failures"), attrs.getValue("errors"), attrs.getValue("time"));
                    this.state = 2;
                    break;
                }
                this.startUnknownElem();
                break;
            }
            case 4: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                this.startUnknownElem();
                break;
            }
            default: {
                assert (this.state < 0);
                ++this.unknownElemNestLevel;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state) {
            case 3: {
                assert (qName.equals("properties"));
                this.state = 2;
                break;
            }
            case 2: {
                assert (qName.equals("testsuite"));
                this.state = 1;
                break;
            }
            case 8: {
                assert (qName.equals("testcase"));
                assert (this.testcase != null);
                this.suite.getTestcases().add(this.testcase);
                this.testcase = null;
                this.state = 2;
                break;
            }
            case 1: {
                assert (false);
                break;
            }
            case 4: {
                assert (qName.equals("property"));
                this.state = 3;
                break;
            }
            case 12: 
            case 13: {
                assert (this.state == 12 && qName.equals("failure") || this.state == 13 && qName.equals("error"));
                assert (this.testcase != null);
                assert (this.trouble != null);
                if (this.charactersBuf != null) {
                    LineNumberReader lnr = new LineNumberReader(new StringReader(this.charactersBuf.toString()));
                    try {
                        String line = lnr.readLine();
                        while (line != null) {
                            this.addStackTraceLine(this.trouble, line, true);
                            line = lnr.readLine();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.charactersBuf = null;
                }
                this.testcase.setTrouble(this.trouble);
                this.trouble = null;
                this.state = 8;
                break;
            }
            case 16: 
            case 17: {
                assert (this.state == 16 && qName.equals("system-out") || this.state == 17 && qName.equals("system-err"));
                if (this.charactersBuf != null) {
                    String[] output = this.getOutput(this.charactersBuf.toString());
                    if (this.state == 16) {
                        // empty if block
                    }
                    this.charactersBuf = null;
                }
                this.state = 2;
                break;
            }
            default: {
                assert (this.state < 0);
                if (--this.unknownElemNestLevel != 0) break;
                this.state = -this.state;
            }
        }
    }

    private void startUnknownElem() {
        this.state = -this.state;
        ++this.unknownElemNestLevel;
    }

    private JUnitTestSuite createSuite(String suiteName, String testsCountStr, String failuresStr, String errorsStr, String timeStr) {
        if (suiteName == null) {
            suiteName = NbBundle.getMessage(XmlOutputParser.class, (String)"UNNKOWN_NAME");
        }
        int timeMillis = this.regexp.parseTimeMillisNoNFE(timeStr);
        JUnitTestSuite testSuite = new JUnitTestSuite(suiteName, this.testSession);
        testSuite.setElapsedTime(timeMillis);
        return testSuite;
    }

    private Testcase createTestcaseReport(String className, String name, String timeStr) {
        JUnitTestcase tc = new JUnitTestcase(name, "JUnit test", this.testSession);
        tc.setClassName(className);
        tc.setTimeMillis(this.regexp.parseTimeMillisNoNFE(timeStr));
        return tc;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        switch (this.state) {
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                if (this.charactersBuf == null) {
                    this.charactersBuf = new StringBuffer(512);
                }
                this.charactersBuf.append(ch, start, length);
            }
        }
    }

    private String[] getOutput(String string) {
        String[] lines = string.split("(?:\\r|\\r\\n|\\n)");
        if (lines.length >= 1 && lines[lines.length - 1].length() == 0) {
            String[] temp = lines;
            if ((lines = new String[lines.length - 1]).length > 0) {
                System.arraycopy(temp, 0, lines, 0, lines.length);
            }
        }
        return lines;
    }

    private void addStackTraceLine(Trouble tr, String line, boolean validateST) {
        String[] stArray;
        if (tr == null || line == null || line.length() == 0 || line.equals("null")) {
            return;
        }
        if (validateST) {
            Pattern[] patterns;
            boolean valid = false;
            for (Pattern pattern : patterns = new Pattern[]{this.regexp.getCallstackLinePattern(), this.regexp.getComparisonHiddenPattern(), this.regexp.getFullJavaIdPattern()}) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                valid = true;
                break;
            }
            if (!valid) {
                return;
            }
        }
        if ((stArray = tr.getStackTrace()) == null) {
            tr.setStackTrace(new String[]{line});
            this.setComparisonFailure(tr, line);
        } else {
            ArrayList<String> stList = new ArrayList<String>(Arrays.asList(this.trouble.getStackTrace()));
            if (!line.startsWith((String)stList.get(stList.size() - 1))) {
                stList.add(line);
                tr.setStackTrace(stList.toArray(new String[stList.size()]));
            }
        }
    }

    private void setComparisonFailure(Trouble tr, String line) {
        Matcher matcher;
        int logPos = line.indexOf("Log:");
        if (logPos > 0) {
            line = line.substring(0, logPos);
        }
        if ((matcher = this.regexp.getComparisonPattern().matcher(line.replaceAll("\n", ""))).matches()) {
            String startExpected = "expected:<";
            String startActual = "> but was:<";
            tr.setComparisonFailure(new Trouble.ComparisonFailure(line.substring(line.indexOf(startExpected) + startExpected.length(), line.indexOf(startActual)), line.substring(line.indexOf(startActual) + startActual.length(), line.length() - 1)));
            return;
        }
        matcher = this.regexp.getComparisonHiddenPattern().matcher(line);
        if (matcher.matches()) {
            tr.setComparisonFailure(new Trouble.ComparisonFailure(matcher.group(1), matcher.group(2)));
            return;
        }
    }
}

