/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.openide.filesystems.FileObject;

final class TopClassFinder {
    private TopClassFinder() {
    }

    static List<ElementHandle<TypeElement>> findTopClasses(JavaSource javaSource) throws IOException {
        TopClassFinderTask analyzer = new TopClassFinderTask();
        javaSource.runUserActionTask((Task)analyzer, true);
        return analyzer.topClassElems;
    }

    static List<ElementHandle<TypeElement>> findMainTopClasses(JavaSource javaSource) throws IOException {
        TopClassFinderTask analyzer = new TopClassFinderTask(new MainClassOnly());
        javaSource.runUserActionTask((Task)analyzer, true);
        return analyzer.topClassElems;
    }

    static List<ElementHandle<TypeElement>> findTestableTopClasses(JavaSource javaSource, TestabilityJudge testabilityJudge, Collection<TestabilityResult.SkippedClass> nonTestable, long skipTestabilityResultMask) throws IOException {
        TopClassFinderTask analyzer = new TopClassFinderTask(new ExtendedTestabilityFilter(testabilityJudge, nonTestable, skipTestabilityResultMask));
        javaSource.runUserActionTask((Task)analyzer, true);
        return analyzer.topClassElems;
    }

    static List<ClassTree> findTopClasses(CompilationUnitTree compilationUnit, TreeUtilities treeUtils) {
        List<? extends Tree> typeDecls = compilationUnit.getTypeDecls();
        if (typeDecls == null || typeDecls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClassTree> result = new ArrayList<ClassTree>(typeDecls.size());
        for (Tree tree : typeDecls) {
            ClassTree clsTree;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !TopClassFinder.isTestable(clsTree = (ClassTree)tree, treeUtils)) continue;
            result.add(clsTree);
        }
        return result;
    }

    private static List<TypeElement> findTopClassElems(CompilationInfo compInfo, CompilationUnitTree compilationUnit, Filter filter) {
        List<? extends Tree> typeDecls = compilationUnit.getTypeDecls();
        if (typeDecls == null || typeDecls.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> result = new ArrayList<TypeElement>(typeDecls.size());
        Trees trees = compInfo.getTrees();
        for (Tree tree : typeDecls) {
            Element element;
            TypeElement typeElement;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !filter.passes(typeElement = (TypeElement)(element = trees.getElement(new TreePath(new TreePath(compilationUnit), tree))), compInfo)) continue;
            result.add(typeElement);
        }
        return result;
    }

    private static List<ElementHandle<TypeElement>> findTopClassElemHandles(CompilationInfo compInfo, CompilationUnitTree compilationUnit, Filter filter) {
        return TopClassFinder.getElemHandles(TopClassFinder.findTopClassElems(compInfo, compilationUnit, filter));
    }

    private static <T extends Element> List<ElementHandle<T>> getElemHandles(List<T> elements) {
        if (elements == null) {
            return null;
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ElementHandle<T>> handles = new ArrayList<ElementHandle<T>>(elements.size());
        for (Element element : elements) {
            handles.add(ElementHandle.create((Element)element));
        }
        return handles;
    }

    private static boolean isTestable(ClassTree typeDecl, TreeUtilities treeUtils) {
        return !treeUtils.isAnnotation(typeDecl);
    }

    static boolean isTestable(TypeElement typeDeclElement) {
        ElementKind elemKind = typeDeclElement.getKind();
        return elemKind != ElementKind.ANNOTATION_TYPE && (elemKind.isClass() || elemKind.isInterface());
    }

    static class BasicTestabilityFilter
    implements Filter {
        BasicTestabilityFilter() {
        }

        @Override
        public boolean passes(TypeElement topClass, CompilationInfo compInfo) {
            ElementKind elemKind = topClass.getKind();
            return elemKind != ElementKind.ANNOTATION_TYPE && (elemKind.isClass() || elemKind.isInterface());
        }
    }

    static final class ExtendedTestabilityFilter
    implements Filter {
        private final TestabilityJudge testabilityJudge;
        private final Collection<TestabilityResult.SkippedClass> nonTestable;
        private final long skipTestabilityResultMask;

        ExtendedTestabilityFilter(TestabilityJudge testabilityJudge, Collection<TestabilityResult.SkippedClass> nonTestable, long skipTestabilityResultMask) {
            this.testabilityJudge = testabilityJudge;
            this.nonTestable = nonTestable;
            this.skipTestabilityResultMask = skipTestabilityResultMask;
        }

        @Override
        public boolean passes(TypeElement topClass, CompilationInfo compInfo) {
            TestabilityResult testabilityStatus = this.testabilityJudge.isClassTestable(compInfo, topClass, this.skipTestabilityResultMask);
            if (testabilityStatus.isTestable()) {
                return true;
            }
            this.nonTestable.add(new TestabilityResult.SkippedClass(topClass.getQualifiedName().toString(), testabilityStatus));
            return false;
        }
    }

    static interface Filter {
        public boolean passes(TypeElement var1, CompilationInfo var2);
    }

    static final class MainClassOnly
    extends BasicTestabilityFilter {
        MainClassOnly() {
        }

        @Override
        public boolean passes(TypeElement topClass, CompilationInfo compInfo) {
            if (!super.passes(topClass, compInfo)) {
                return false;
            }
            FileObject javaFileObj = compInfo.getFileObject();
            ClassPath sourceCP = compInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
            String qualifiedClassName = topClass.getQualifiedName().toString();
            return qualifiedClassName.equals(sourceCP.getResourceName(javaFileObj, '.', false));
        }
    }

    private static class TopClassFinderTask
    implements CancellableTask<CompilationController> {
        private final Filter filter;
        private List<ElementHandle<TypeElement>> topClassElems;
        private volatile boolean cancelled;

        private TopClassFinderTask() {
            this(new BasicTestabilityFilter());
        }

        private TopClassFinderTask(Filter filter) {
            this.filter = filter;
        }

        public void run(CompilationController controller) throws IOException {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            if (this.cancelled) {
                return;
            }
            if (this.topClassElems == null) {
                this.topClassElems = new ArrayList<ElementHandle<TypeElement>>(10);
            }
            this.topClassElems.addAll(TopClassFinder.findTopClassElemHandles((CompilationInfo)controller, controller.getCompilationUnit(), this.filter));
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

