/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.infomanLite.model;

public class CRC8 {
    private static byte[] dscrc_table = new byte[256];

    private CRC8() {
    }

    public static int compute(int dataToCRC, int seed) {
        return dscrc_table[(seed ^ dataToCRC) & 0xFF] & 0xFF;
    }

    public static int compute(int dataToCRC) {
        return dscrc_table[dataToCRC & 0xFF] & 0xFF;
    }

    public static int compute(byte[] dataToCrc) {
        return CRC8.compute(dataToCrc, 0, dataToCrc.length);
    }

    public static int compute(byte[] dataToCrc, int off, int len) {
        return CRC8.compute(dataToCrc, off, len, 0);
    }

    public static int compute(byte[] dataToCrc, int off, int len, int seed) {
        int CRC82 = seed;
        for (int i = 0; i < len; ++i) {
            CRC82 = dscrc_table[(CRC82 ^ dataToCrc[i + off]) & 0xFF];
        }
        return CRC82 & 0xFF;
    }

    public static int compute(byte[] dataToCrc, int seed) {
        return CRC8.compute(dataToCrc, 0, dataToCrc.length, seed);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int acc = i;
            int crc = 0;
            for (int j = 0; j < 8; ++j) {
                crc = ((acc ^ crc) & 1) == 1 ? (crc ^ 0x18) >> 1 | 0x80 : (crc >>= 1);
                acc >>= 1;
            }
            CRC8.dscrc_table[i] = (byte)crc;
        }
    }
}

