/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.infomanLite;

import de.proveo.event.infomanLite.EndpointStatus;
import de.proveo.event.infomanLite.InfomanLiteConnectionHandler;
import de.proveo.event.util.raw.AbstractRawEndpointInitServlet;
import de.proveo.event.util.raw.Worker;
import de.proveo.event.util.raw.WorkerPool;
import de.proveo.event.util.raw.tcp.StreamConnectionHandler;
import de.proveo.event.util.raw.tcp.StreamWorker;
import de.proveo.rts.configuration.interfaces.event.EventInterfaceMBean;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import java.io.IOException;
import java.net.ServerSocket;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfomanLiteEndpointInitServlet
extends AbstractRawEndpointInitServlet {
    private static final Log log = LogFactory.getLog(InfomanLiteEndpointInitServlet.class);
    private ThreadGroup threadGroup;
    private final WorkerPool workerPool = new WorkerPool(log){
        int index;

        protected Worker createWorker() {
            StreamWorker worker = new StreamWorker(InfomanLiteEndpointInitServlet.this.threadGroup, InfomanLiteEndpointInitServlet.this.getThreadNamePrefix() + "-" + this.index++, InfomanLiteEndpointInitServlet.this.serverSocket);
            worker.setSocketTimeout(InfomanLiteEndpointInitServlet.this.socketTimeout);
            worker.setEventInterfaceMBean(InfomanLiteEndpointInitServlet.this.eventInterfaceMBean);
            InfomanLiteConnectionHandler handler = new InfomanLiteConnectionHandler();
            handler.setEventMapping(InfomanLiteEndpointInitServlet.this.getEventMapping());
            handler.setUnitFacadeRemote(InfomanLiteEndpointInitServlet.this.getUnitFacadeRemote());
            handler.setCustomScriptFacadeRemote(InfomanLiteEndpointInitServlet.this.getCustomScriptFacadeRemote());
            handler.setTcpBeginConnectionMonitoringMBean(InfomanLiteEndpointInitServlet.this.tcpBeginConnectionMonitoringMBean);
            handler.setTcpEndConnectionMonitoringMBean(InfomanLiteEndpointInitServlet.this.tcpEndConnectionMonitoringMBean);
            handler.setEfmEventmonitoringMBean(InfomanLiteEndpointInitServlet.this.efmEventMonitoringMBean);
            handler.setRawEventmonitoringMBean(InfomanLiteEndpointInitServlet.this.rawEventMonitoringMBean);
            handler.setEventInterfaceMBean(InfomanLiteEndpointInitServlet.this.eventInterfaceMBean);
            handler.setGroovyFailuresMontoringMBean(InfomanLiteEndpointInitServlet.this.groovyFailuresMontoringMBean);
            handler.setHardChecksumCheckEnabled(InfomanLiteEndpointInitServlet.this.hardChecksumCheckEnabled);
            worker.setConnectionHandler((StreamConnectionHandler)handler);
            return worker;
        }
    };
    ServerSocket serverSocket;
    private boolean hardChecksumCheckEnabled;
    private MonitoringMBean tcpBeginConnectionMonitoringMBean;
    private MonitoringMBean tcpEndConnectionMonitoringMBean;
    private MonitoringMBean rawEventMonitoringMBean;
    private MonitoringMBean efmEventMonitoringMBean;
    private EventInterfaceMBean eventInterfaceMBean;
    private MonitoringMBean groovyFailuresMontoringMBean;
    private int socketTimeout;

    public InfomanLiteEndpointInitServlet() {
        super(log);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ConfigurationClient configClient = new ConfigurationClient();
        try {
            if (configClient.getBoolean("infoman.event.infomanLite")) {
                this.hardChecksumCheckEnabled = configClient.getBoolean("infoman.event.infomanLite.checksumEnabled");
                this.serverSocket = new ServerSocket(configClient.getInteger("infoman.event.infomanLite.port"), configClient.getInteger("infoman.event.infomanLite.backLog"), configClient.getInetAddress("infoman.event.infomanLite.bindAddr"));
                this.threadGroup = new ThreadGroup(this.getServletName());
                this.workerPool.setPoolSize(configClient.getInteger("infoman.event.infomanLite.threadCount"));
                this.socketTimeout = configClient.getInteger("infoman.event.infomanLite.socketTimeout");
                this.tcpBeginConnectionMonitoringMBean = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "InfomanLiteBeginTCPConnections");
                this.tcpEndConnectionMonitoringMBean = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "InfomanLiteEndTCPConnections");
                this.rawEventMonitoringMBean = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "InfomanLiteEvents");
                this.efmEventMonitoringMBean = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "InfomanLiteEFMEvents");
                this.eventInterfaceMBean = (EventInterfaceMBean)ServiceFactory.getInstance().getService(EventInterfaceMBean.class, "InfomanLiteEventInterface");
                this.groovyFailuresMontoringMBean = (MonitoringMBean)ServiceFactory.getInstance().getService(MonitoringMBean.class, "InfomanLiteGroovyFailures");
                this.eventInterfaceMBean.setAcceptFaultyEventsPersistent(this.getConfigurationRemote().getBoolean("infoman.event.infomanLite.acceptFaultyEvents"));
                EndpointStatus.setWorkerPool(this.workerPool);
                this.workerPool.start();
            }
        }
        catch (Exception ex) {
            this.closeServerSocketSiletly();
            throw new ServletException((Throwable)ex);
        }
    }

    void closeServerSocketSiletly() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                log.error((Object)"close()", (Throwable)ex);
            }
        }
    }

    public void destroy() {
        this.workerPool.stop();
        this.closeServerSocketSiletly();
        super.destroy();
    }
}

