/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.infomanLite;

import de.proveo.event.infomanLite.model.InfomanLiteEvent;
import de.proveo.event.infomanLite.model.InfomanLiteSession;
import de.proveo.event.util.RawEventResponse;
import de.proveo.event.util.efm.EFMEventUtil;
import de.proveo.event.util.efm.groovy.EventParser;
import de.proveo.event.util.raw.ByteArrayLittleEndianParser;
import de.proveo.event.util.raw.ByteUtil;
import de.proveo.event.util.raw.tcp.AbstractTCPConnectionHandler;
import de.proveo.eventbase.EventPayload;
import de.proveo.eventbase.EventResponse;
import de.proveo.wwt.logic.ejb.general.custom.ScriptLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InfomanLiteConnectionHandler
extends AbstractTCPConnectionHandler {
    private static final Log log = LogFactory.getLog(InfomanLiteConnectionHandler.class);
    private boolean hardChecksumCheckEnabled;
    private byte[] pendingCommand;
    protected static final byte[] eoc_OK = "\r\nOK\r\n".getBytes();
    protected static final byte[] eoc_ERROR = "\r\nERROR\r\n".getBytes();
    private ApplicationLayerInStatus applicationLayoutInStatus = ApplicationLayerInStatus.WAITING_FOR_FRAME_HEADER;
    protected static final int[] crcTable = new int[]{0, 94, 188, 226, 97, 63, 221, 131, 194, 156, 126, 32, 163, 253, 31, 65, 157, 195, 33, 127, 252, 162, 64, 30, 95, 1, 227, 189, 62, 96, 130, 220, 35, 125, 159, 193, 66, 28, 254, 160, 225, 191, 93, 3, 128, 222, 60, 98, 190, 224, 2, 92, 223, 129, 99, 61, 124, 34, 192, 158, 29, 67, 161, 255, 70, 24, 250, 164, 39, 121, 155, 197, 132, 218, 56, 102, 229, 187, 89, 7, 219, 133, 103, 57, 186, 228, 6, 88, 25, 71, 165, 251, 120, 38, 196, 154, 101, 59, 217, 135, 4, 90, 184, 230, 167, 249, 27, 69, 198, 152, 122, 36, 248, 166, 68, 26, 153, 199, 37, 123, 58, 100, 134, 216, 91, 5, 231, 185, 140, 210, 48, 110, 237, 179, 81, 15, 78, 16, 242, 172, 47, 113, 147, 205, 17, 79, 173, 243, 112, 46, 204, 146, 211, 141, 111, 49, 178, 236, 14, 80, 175, 241, 19, 77, 206, 144, 114, 44, 109, 51, 209, 143, 12, 82, 176, 238, 50, 108, 142, 208, 83, 13, 239, 177, 240, 174, 76, 18, 145, 207, 45, 115, 202, 148, 118, 40, 171, 245, 23, 73, 8, 86, 180, 234, 105, 55, 213, 139, 87, 9, 235, 181, 54, 104, 138, 212, 149, 203, 41, 119, 244, 170, 72, 22, 233, 183, 85, 11, 136, 214, 52, 106, 43, 117, 151, 201, 74, 20, 246, 168, 116, 42, 200, 150, 21, 75, 169, 247, 182, 232, 10, 84, 215, 137, 107, 53};
    private static final String PARSE_ENTRY_POINT = "infoman.event.infomanLite.parseEvent";
    private static final ScriptLoader<EventParser> eventParserScriptLoader = new ScriptLoader();

    public boolean isHardChecksumCheckEnabled() {
        return this.hardChecksumCheckEnabled;
    }

    public void setHardChecksumCheckEnabled(boolean hardChecksumCheckEnabled) {
        this.hardChecksumCheckEnabled = hardChecksumCheckEnabled;
    }

    private InfomanLiteSession readSession() throws IOException {
        byte[] session = new byte[8];
        int count = this.in.read(session);
        if (count == -1) {
            return null;
        }
        if (count != 8) {
            throw new IOException("corrupt session. read count:" + count);
        }
        InfomanLiteSession infomanLiteSession = new InfomanLiteSession(session);
        return infomanLiteSession;
    }

    protected void writeDataAcceptResponse(InfomanLiteEvent event, RawEventResponse eventResponse) throws IOException {
        String msg = "A";
        this.out.write("A".getBytes());
        this.out.flush();
        String id = this.getIdentification();
        byte[] message = this.getEventInterfaceMBean().getAndClearMessage(id);
        if (message != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(this.getIdentification() + ": send '" + new String(message) + "'"));
            }
            this.pendingCommand = message;
            this.out.write(message);
            this.out.flush();
        }
        this.handleDataSyncJob(eventResponse);
    }

    protected byte[] readCommandResponse() throws IOException {
        boolean endOfCommand;
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        response.write(13);
        response.write(10);
        do {
            int c;
            if ((c = this.in.read()) == -1) {
                log.warn((Object)"endOfCommand by EOF!?");
                endOfCommand = true;
                continue;
            }
            response.write(c);
            endOfCommand = this.isEndOfCommandReached(response);
        } while (!endOfCommand);
        return response.toByteArray();
    }

    protected boolean isEndOfCommandReached(ByteArrayOutputStream response) {
        byte[] buffer = response.toByteArray();
        if (buffer.length >= eoc_OK.length && ByteUtil.equals((byte[])buffer, (int)(buffer.length - eoc_OK.length), (byte[])eoc_OK, (int)0, (int)eoc_OK.length)) {
            return true;
        }
        return buffer.length >= eoc_ERROR.length && ByteUtil.equals((byte[])buffer, (int)(buffer.length - eoc_ERROR.length), (byte[])eoc_OK, (int)0, (int)eoc_ERROR.length);
    }

    String lazyToString(byte[] response) {
        if (response == null) {
            return null;
        }
        return new String(response);
    }

    protected void handleCommandResponse(byte[] response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getIdentification() + ": command '" + this.lazyToString(this.pendingCommand) + "' returned: '" + this.lazyToString(response) + "'"));
        }
        this.pendingCommand = null;
    }

    public String getApplicationLayerStatus() {
        switch (this.applicationLayoutInStatus) {
            case READING_COMMAND_RESPONSE: {
                return ApplicationLayerInStatus.READING_COMMAND_RESPONSE.toString();
            }
        }
        return super.getApplicationLayerStatus();
    }

    protected ByteArrayLittleEndianParser waitForFrameHeader() throws IOException {
        byte[] header = new byte[2];
        ByteArrayLittleEndianParser headerParser = null;
        boolean frameHeaderFound = false;
        do {
            block0 : switch (this.applicationLayoutInStatus) {
                case WAITING_FOR_FRAME_HEADER: {
                    int count = this.in.read(header);
                    if (count == -1) {
                        return null;
                    }
                    if (count != 2) {
                        throw new IOException("corrupt header. read count:" + count);
                    }
                    headerParser = new ByteArrayLittleEndianParser(header);
                    switch (headerParser.getUnsignedByte(0)) {
                        case 224: {
                            frameHeaderFound = true;
                            break block0;
                        }
                        case 13: {
                            if (headerParser.getUnsignedByte(1) != 10) break;
                            this.applicationLayoutInStatus = ApplicationLayerInStatus.READING_COMMAND_RESPONSE;
                            break block0;
                        }
                    }
                    throw new IOException("corrupt header. " + ByteUtil.toHexString((byte[])header));
                }
                case READING_COMMAND_RESPONSE: {
                    byte[] response = this.readCommandResponse();
                    this.handleCommandResponse(response);
                    this.applicationLayoutInStatus = ApplicationLayerInStatus.WAITING_FOR_FRAME_HEADER;
                }
            }
        } while (!frameHeaderFound);
        return headerParser;
    }

    private InfomanLiteEvent readEvent() throws IOException {
        byte[] data;
        int count;
        ByteArrayLittleEndianParser headerParser = this.waitForFrameHeader();
        if (headerParser == null) {
            throw new IOException("connection closed");
        }
        int dataLength = InfomanLiteEvent.parseHeader(headerParser);
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.getIdentification() + ": wait for bytes: " + dataLength));
        }
        if ((count = this.in.read(data = new byte[dataLength])) != data.length) {
            throw new IOException("data broken. read: " + count);
        }
        int checksum = ByteUtil.getInteger((byte)data[data.length - 1]);
        InfomanLiteEvent event = new InfomanLiteEvent(Arrays.copyOfRange(data, 0, data.length - 1), dataLength, checksum);
        this.compareChecksum(event);
        return event;
    }

    protected void compareChecksum(InfomanLiteEvent event) throws IOException {
        int calculatedChecksum;
        try {
            calculatedChecksum = this.calculateChecksum(event.toByteArray());
        }
        catch (Exception ex) {
            if (this.hardChecksumCheckEnabled) {
                throw new IOException(ex);
            }
            log.warn((Object)(this.getIdentification() + ": runs during calculate checksum into"), (Throwable)ex);
            return;
        }
        if (calculatedChecksum != event.getChecksum()) {
            String msg = this.getIdentification() + ": wrong checksum. got:" + event.getChecksum() + " expected:" + calculatedChecksum;
            if (this.hardChecksumCheckEnabled) {
                throw new IOException(msg);
            }
            log.warn((Object)msg);
        }
    }

    private int calculateChecksum(byte[] eventData) {
        int crc = 0;
        for (int i = 0; i < eventData.length - 1; ++i) {
            int data = ByteUtil.getInteger((byte)eventData[i]);
            crc = crcTable[crc ^ data];
        }
        return crc;
    }

    public InfomanLiteConnectionHandler() {
        super(log);
    }

    protected void processData() throws IOException {
        InfomanLiteEvent event;
        InfomanLiteSession infomanLiteSession = this.readSession();
        List<Long> unitIds = this.lookupUnitId(infomanLiteSession.getIMEI());
        this.setIdentification(infomanLiteSession.getIMEI());
        do {
            if ((event = this.readEvent()) == null) continue;
            event.setSerialNumber(infomanLiteSession.getIMEI());
            long eventReceiveTime = System.currentTimeMillis();
            RawEventResponse eventResponse = this.handleRawEvent(event, eventReceiveTime, unitIds);
            this.writeDataAcceptResponse(event, eventResponse);
        } while (event != null);
    }

    private List<Long> lookupUnitId(String id) {
        return this.getUnitFacadeRemote().findBySerialNumber(id);
    }

    protected String getParseEntryPoint() {
        return PARSE_ENTRY_POINT;
    }

    protected ScriptLoader<EventParser> getParseEntryPointLoader() {
        return eventParserScriptLoader;
    }

    protected Properties createEasyInstallEvent(Map<String, Object> parsedEventParameters, Map<String, Object> metaInfo) {
        Properties easyInstallEvent = new Properties();
        EFMEventUtil.addZeroConfParameters((Properties)easyInstallEvent, (long)((Long)parsedEventParameters.get("timestamp")), metaInfo);
        return easyInstallEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void handleDataSyncJob(RawEventResponse rawEventResponse) throws IOException {
        if (rawEventResponse == null || rawEventResponse.getEventResponses() == null) {
            return;
        }
        for (EventResponse eventResponse : rawEventResponse.getEventResponses()) {
            payloads = eventResponse.getPayloads();
            payIt = payloads.iterator();
            while (payIt.hasNext()) {
                atCommand = null;
                payload = (EventPayload)payIt.next();
                if (payload.getName().startsWith("DSYNC")) {
                    props = new Properties();
                    bis = new ByteArrayInputStream(payload.getPayload());
                    try {
                        props.load(bis);
                        if ("softwareUpdate".equals(props.getProperty("ti"))) {
                            atCommand = "AT+PRVDOTA=1,\"/datasync/info/task/" + props.getProperty("tid") + "/resource/" + props.getProperty("trid") + "?id=" + props.getProperty("tid") + "\"";
                        }
                        if ("aclUpdate".equals(props.getProperty("ti"))) {
                            atCommand = "AT+PRVACLUP=\"/datasync/info/task/" + props.getProperty("tid") + "/resource/" + props.getProperty("trid") + "?id=" + props.getProperty("tid") + "\"";
                        }
                        if (!InfomanLiteConnectionHandler.log.isWarnEnabled()) ** GOTO lbl30
                        InfomanLiteConnectionHandler.log.warn((Object)("Unknown DataSync job type '" + props.getProperty("ti") + "'"));
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)bis);
                    }
                } else if (payload.getName().equals("ACLUpdate")) {
                    token = Long.parseLong(new String(payload.getPayload()));
                    efmUnitIds = (List)rawEventResponse.getMetaInfo().get("efm.unitIds");
                    atCommand = "AT+PRVACLUP=\"/datain/infomanLite/acl?id=" + token + "&u=" + efmUnitIds.get(0) + "\"";
                }
lbl30:
                // 7 sources

                if (atCommand == null) continue;
                this.out.write(atCommand.getBytes());
                this.out.flush();
                return;
            }
        }
    }

    static enum ApplicationLayerInStatus {
        WAITING_FOR_FRAME_HEADER,
        READING_COMMAND_RESPONSE;

    }
}

