/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.infomanLite;

import de.proveo.event.util.raw.WorkerMonitoring;
import de.proveo.event.util.raw.WorkerPool;
import de.proveo.event.util.raw.WorkerStatusInfo;
import java.util.ArrayList;
import java.util.Collection;

public class EndpointStatus {
    private static WorkerPool workerPool;
    private final Collection<WorkerStatusInfo> workerStatus = new ArrayList<WorkerStatusInfo>();
    private int poolSize;
    private int stateWaiting;
    private int stateConnected;
    private int stateDisconnected;

    public static void setWorkerPool(WorkerPool pool) {
        workerPool = pool;
    }

    public EndpointStatus() {
        if (workerPool != null) {
            for (WorkerMonitoring monitor : workerPool.getWorkerMonitoring()) {
                WorkerStatusInfo status = monitor.getWorkerStatusInfo();
                ++this.poolSize;
                switch (status.getStatus()) {
                    case WAITING: {
                        ++this.stateWaiting;
                        break;
                    }
                    case CONNECTED: {
                        ++this.stateConnected;
                        break;
                    }
                    case DISCONNECTED: {
                        ++this.stateDisconnected;
                    }
                }
                this.workerStatus.add(status);
            }
        }
    }

    public boolean isStatusAvailable() {
        return this.workerStatus != null;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getStateConnected() {
        return this.stateConnected;
    }

    public int getStateDisconnected() {
        return this.stateDisconnected;
    }

    public int getStateWaiting() {
        return this.stateWaiting;
    }

    public Collection<WorkerStatusInfo> getWorkerStatus() {
        return this.workerStatus;
    }
}

