/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.test;

import de.proveo.eventbase.codec.ResponseDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class MultiEventServletTest {
    Properties p = new Properties();
    String servletUrl = "";
    int badCalls = 0;
    int goodCalls = 0;
    private String aliasCompressedEventServlet = "datain/c";
    private String aliasUncompressedEventServlet = "datain/e";
    private String host = "localhost";
    private String port = "8080";
    private String sClassName = this.getClass().getName();

    public void callGet(Properties p) throws Exception {
        String sMethodName = "callGet(): ";
        this.servletUrl = "http://" + this.host + ":" + this.port + "/" + this.aliasUncompressedEventServlet;
        HttpClient client = new HttpClient();
        String response = "";
        String url = this.servletUrl + "?";
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            url = url + key + '=' + p.getProperty(key) + '&';
        }
        url = url.substring(0, url.length() - 1);
        System.out.println(sMethodName + "Aufruf MultiEventServlet via GET URL Parameter:");
        System.out.println(sMethodName + "  url=" + url);
        GetMethod get = new GetMethod(url);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status != 200) {
                System.out.println(sMethodName + "ERROR, server returns status " + status);
                ++this.badCalls;
                return;
            }
            response = get.getResponseBodyAsString();
            System.out.println(sMethodName + "status=" + status + "\n" + response);
        }
        catch (HttpException e) {
            System.out.println(sMethodName + "runs into HttpException: " + e.getMessage());
            e.printStackTrace();
            ++this.badCalls;
            throw new Exception("HttpException");
        }
        catch (IOException ioe) {
            String msg = "IOException: Servlet not accessible ? Server not running ?";
            System.out.println(sMethodName + msg);
            ++this.badCalls;
            throw new Exception(msg);
        }
        finally {
            get.releaseConnection();
        }
        this.analyzeResponse(response);
    }

    public void callPost(Properties p) throws Exception {
        String sMethodName = "callPost(): ";
        this.servletUrl = "http://" + this.host + ":" + this.port + "/" + this.aliasCompressedEventServlet;
        URL url = new URL(this.servletUrl);
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        httpConnection.setDoOutput(true);
        PrintStream out = new PrintStream(new GZIPOutputStream(httpConnection.getOutputStream()));
        Enumeration<Object> en = p.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            out.print(key);
            out.print('=');
            out.println(p.getProperty(key));
        }
        out.close();
        int status = httpConnection.getResponseCode();
        if (status != 200) {
            System.out.println(sMethodName + "ERROR, server returns status " + status);
            ++this.badCalls;
            return;
        }
        long length = httpConnection.getContentLength();
        if (length == -1L) {
            System.out.println(sMethodName + "Reading from an HTTP 1.0 server or a chunked HTTP 1.1");
            ++this.badCalls;
            return;
        }
        System.out.println(sMethodName + "Reading content with length " + length);
        String response = "";
        InputStream inputStream = httpConnection.getInputStream();
        int MAX_RESPONSE_LENGTH = 5;
        long l = length = length > 5L ? 5L : length;
        if (length > 0L) {
            byte[] byteArray = new byte[(int)length];
            int readed = 0;
            while ((long)(readed += inputStream.read(byteArray, readed, byteArray.length - readed)) < length) {
            }
            response = new String(byteArray);
        }
        this.analyzeResponse(response);
    }

    public static void main(String[] args) {
        System.out.println(" main() entered...");
        MultiEventServletTest test = new MultiEventServletTest();
        test.run();
    }

    public void run() {
        String sMethodName = "run()";
        try {
            String ori = "Motor noetig ?????";
            String enc = URLEncoder.encode("Motor noetig ?????", "UTF-8");
            String dec = URLDecoder.decode(enc, "UTF-8");
            System.out.println("Test UTF-8 encoding: ori='" + ori + "', enc='" + enc + "', dec='" + dec + "'");
            this.p.clear();
            this.p.setProperty("u", "203");
            this.p.setProperty("t", "" + System.currentTimeMillis());
            this.p.setProperty("m", "2010");
            this.p.setProperty("s", "2012");
            this.p.setProperty("c", URLEncoder.encode("Motor noetig ?????", "ISO-8859-1"));
            this.callGet(this.p);
            this.p.setProperty("s", "2011");
            System.out.println("encode 'Motor aus ?????' to '" + URLEncoder.encode("Motor aus ?????'", "UTF-8"));
            this.p.setProperty("c", URLEncoder.encode("Motor aus ?????", "UTF-8"));
            this.callPost(this.p);
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.toString());
        }
    }

    private void analyzeResponse(String response) {
        String sMethodName = "analyzeResponse(): ";
        System.out.println(sMethodName + "response='" + response + "'");
        ResponseDecoder decoder = new ResponseDecoder();
        decoder.decode(response.getBytes());
        boolean success = decoder.isEventResponse();
        boolean callback = decoder.isVPN();
        System.out.println(sMethodName + "success='" + success + "', callback='" + callback + "'");
        if (success) {
            ++this.goodCalls;
        } else {
            ++this.badCalls;
        }
    }
}

