/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.general.infoman;

import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacade;
import de.proveo.wwt.logic.ejb.general.infoman.InfomanSetupFacadeUtil;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.ObjectNotFoundException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UpdateResourceServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(UpdateResourceServlet.class);
    private static final long serialVersionUID = -295451766588408619L;
    private InfomanSetupFacade infomanSetupFacade;

    public String getServletInfo() {
        return "Resource Servlet for planned infoman updates";
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.infomanSetupFacade = InfomanSetupFacadeUtil.getHome().create();
        }
        catch (Exception ex) {
            throw new ServletException("Cannot connect to InfomanSetupFacade", (Throwable)ex);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected Properties getPropertiesFromRequest(HttpServletRequest request) {
        Properties event = new Properties();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            event.setProperty(key, request.getParameter(key));
        }
        return event;
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Properties properties = this.getPropertiesFromRequest(request);
        byte[] resource = null;
        try {
            resource = this.infomanSetupFacade.getUpdateResource(properties);
        }
        catch (ObjectNotFoundException ex) {
            log.error((Object)"processRequest() runs into", (Throwable)ex);
            response.sendError(404, ex.getMessage());
            return;
        }
        catch (RemoteException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        if (resource == null) {
            log.trace((Object)"update canceled");
            response.sendError(404, "update canceled");
            return;
        }
        if (properties.getProperty("type", "none").equals("software")) {
            response.setContentType("application/x-tar");
        } else if (properties.getProperty("type", "none").equals("config")) {
            response.setContentType("text/plain");
        }
        ServletOutputStream out = response.getOutputStream();
        out.write(resource);
        out.close();
    }
}

