/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.general;

import de.proveo.util.connection.LoginResponse;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.exception.AccessDeniedException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacade;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.facade.UserAdminFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountDataWithPermissions;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginHandler
implements SimpleRPCHandler {
    private static final Log log = LogFactory.getLog(LoginHandler.class);
    public static final String CLIENT_TYPE_AIRPORTMAP_GENERATOR = "apmg";
    public static final String ROLE_AIRPORTMAP_GENERATOR = "section.airportmapgenerator";
    public static final String ROLE_AIRPORTMAP_GENERATOR_ADMIN = "section.airportmapgenerator_admin";
    public static final String ROLE_AIRPORTMAP_GENERATOR_AIRPORTMAP_AREAS = "section.airportmapgenerator.airportmap";
    public static final String ROLE_AIRPORTMAP_GENERATOR_GEOFENCING_AREAS = "section.airportmapgenerator.geofencing";
    public static final String LOGIN_FAILED_REASON_USER_BLOCKED = "userBlocked";
    public static final String PARAM_CLIENT_TYPE = "client";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    protected static final String INIT_PARAM_USERADMIN_JNDI_NAME = "UserAdminJNDI";
    private UserAdminFacade userAdminFacade;

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        Object passwordHashParameter;
        String username = null;
        char[] passwordHash = null;
        Object usernameParameter = call.getParameter(PARAM_USERNAME);
        if (usernameParameter != null) {
            username = (String)usernameParameter;
        }
        if ((passwordHashParameter = call.getParameter(PARAM_PASSWORD)) != null) {
            passwordHash = (char[])passwordHashParameter;
        }
        if (username == null || username.length() == 0) {
            throw new ServletException("parameter 'username' missing or empty");
        }
        if (passwordHash == null || passwordHash.length == 0) {
            throw new ServletException("parameter 'password' missing or empty");
        }
        LoginContextUtil lcu = null;
        LoginResponse loginResponse = new LoginResponse(false);
        try {
            lcu = new LoginContextUtil(username, passwordHash);
            loginResponse = new LoginResponse(true);
            loginResponse.setPortalPermissions((Collection)lcu.getRoles());
        }
        catch (LoginException e1) {
            loginResponse = new LoginResponse(false);
            if (this.userAdminFacade == null) {
                throw new ServletException("ejb remote interface missing. init problem");
            }
            try {
                AccountDataWithPermissions account = this.userAdminFacade.checkUser(username, new String(passwordHash));
                if (account.getBlockOut()) {
                    ArrayList<String> permissions = new ArrayList<String>();
                    permissions.add(LOGIN_FAILED_REASON_USER_BLOCKED);
                    loginResponse = new LoginResponse(false);
                    loginResponse.setPortalPermissions(permissions);
                } else {
                    loginResponse = new LoginResponse(true);
                }
            }
            catch (AccessDeniedException ex) {
                loginResponse = new LoginResponse(false);
            }
        }
        return loginResponse;
    }

    public String getMethodName() {
        return "Login";
    }

    public void init() throws Exception {
        this.userAdminFacade = UserAdminFacadeUtil.getHome().create();
    }

    public boolean isDisabled() {
        return false;
    }
}

