/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.generator;

import de.proveo.rts.configuration.map.AirportMapGeneratorMBean;
import de.proveo.rts.configuration.map.AirportMapGeneratorUtil;
import de.proveo.util.connection.UserNotInRoleException;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacade;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsValue;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.Configuration;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SetAreasHandler
implements SimpleRPCHandler {
    private static final Log log = LogFactory.getLog(SetAreasHandler.class);
    private Configuration configuration;
    private AreaInFacade areaInFacade;
    private AirportMapGeneratorMBean airportMapGeneratorConfig;

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        boolean admin;
        String username = "";
        char[] password = new char[]{};
        Object usernameParameter = call.getParameter("username");
        Object passwordParameter = call.getParameter("password");
        if (usernameParameter != null) {
            username = usernameParameter.toString();
        }
        if (passwordParameter != null) {
            password = (char[])passwordParameter;
        }
        LoginContextUtil lcu = null;
        try {
            lcu = new LoginContextUtil(username, password);
        }
        catch (LoginException ex) {
            log.warn((Object)("Login failed for user '" + username + "'!"));
            throw ex;
        }
        boolean bl = admin = lcu.isSuperAdmin() || lcu.isUserInRole("section.airportmapgenerator_admin");
        if (!admin && !lcu.isUserInRole("section.airportmapgenerator")) {
            throw new UserNotInRoleException("User '" + username + "' is not in role " + "section.airportmapgenerator" + "!");
        }
        Object areasParameter = call.getParameter("areas");
        if (areasParameter == null || !(areasParameter instanceof HashMap)) {
            throw new ServletException("no areas given to update!");
        }
        Long airportId = -1L;
        Object airportIdParameter = call.getParameter("airportId");
        if (airportIdParameter != null) {
            log.debug((Object)("Found airportId '" + airportId + "' in parameters."));
            airportId = Long.parseLong(airportIdParameter.toString());
        } else {
            airportId = null;
        }
        boolean writeGeoFencing = false;
        boolean writeNonGeoFencing = false;
        HashMap areasMap = (HashMap)areasParameter;
        HashMap areas = new HashMap();
        HashMap points = new HashMap();
        for (Object key : areasMap.keySet()) {
            int areaId = -1;
            try {
                areaId = Integer.valueOf(key.toString());
            }
            catch (Throwable ex) {
                areaId = -1;
            }
            HashMap areaValues = (HashMap)areasMap.get(key);
            String areaName = (String)areaValues.get("area_name");
            String areaDesc = (String)areaValues.get("area_desc");
            Integer areaPrio = (Integer)areaValues.get("area_prio");
            boolean areaDeleted = (Boolean)areaValues.get("area_del");
            boolean areaGeoFencing = (Boolean)areaValues.get("area_geoFenc");
            ArrayList areaPoints = (ArrayList)areaValues.get("area_points");
            if (areaGeoFencing) {
                writeGeoFencing = true;
            } else {
                writeNonGeoFencing = true;
            }
            AreaValue areaValue = new AreaValue();
            if (areaId >= 0) {
                areaValue.setAreaId(areaId);
            }
            areaValue.setArea(areaName);
            areaValue.setDescription(areaDesc);
            areaValue.setPriority(areaPrio.intValue());
            areaValue.setIsGeofencing(areaGeoFencing);
            areaValue.setDeleted(areaDeleted);
            ArrayList<AreaPointsValue> pointValues = new ArrayList<AreaPointsValue>();
            for (Point point : areaPoints) {
                AreaPointsValue areaPointsValue = new AreaPointsValue();
                areaPointsValue.setLongMsec((int)point.getX());
                areaPointsValue.setLatMsec((int)point.getY());
                pointValues.add(areaPointsValue);
            }
            areas.put(key, areaValue);
            points.put(key, pointValues);
        }
        if (writeNonGeoFencing && writeGeoFencing) {
            throw new UnsupportedOperationException("Client sends both types of areas at one time, this is not supported!");
        }
        if (!admin && writeNonGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.airportmap")) {
            throw new UserNotInRoleException("User '" + username + "' is not in the needed role for this operation: " + "section.airportmapgenerator.airportmap");
        }
        if (!admin && writeGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.geofencing")) {
            throw new UserNotInRoleException("User '" + username + "' is not in the needed role for this operation: " + "section.airportmapgenerator.geofencing");
        }
        log.debug((Object)("Add/Update/Delete " + areas.size() + " area(s) for airport id '" + airportId + "'."));
        this.areaInFacade.updateAllAreas(areas, points, airportId);
        return null;
    }

    public String getMethodName() {
        return "SetAreas";
    }

    public void init() throws Exception {
        this.areaInFacade = AreaInFacadeUtil.getHome().create();
        this.configuration = ConfigurationUtil.getHome().create();
        this.airportMapGeneratorConfig = AirportMapGeneratorUtil.getMBean();
    }

    public boolean isDisabled() {
        return this.airportMapGeneratorConfig.isClientsDisabled();
    }
}

