/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.generator;

import de.proveo.rts.configuration.map.AirportMapGeneratorMBean;
import de.proveo.rts.configuration.map.AirportMapGeneratorUtil;
import de.proveo.util.connection.UserNotInRoleException;
import de.proveo.wwt.logic.app.security.LoginContextUtil;
import de.proveo.wwt.logic.ejb.general.area.Area;
import de.proveo.wwt.logic.ejb.general.area.AreaHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPoints;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.Configuration;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetAreasHandler
implements SimpleRPCHandler {
    private static final Log log = LogFactory.getLog(GetAreasHandler.class);
    private Configuration configuration;
    private AreaHome areaHome;
    private AreaPointsHome areaPointsHome;
    private AirportMapGeneratorMBean airportMapGeneratorConfig;

    public Object execute(SimpleXMLRPCCall call) throws Exception {
        Collection areaEntities;
        Object sendGeoFencingParameter;
        boolean admin;
        HashMap areasHashMap = new HashMap();
        String username = "";
        char[] password = new char[]{};
        Object usernameParameter = call.getParameter("username");
        Object passwordParameter = call.getParameter("password");
        if (usernameParameter != null) {
            username = usernameParameter.toString();
        }
        if (passwordParameter != null) {
            password = (char[])passwordParameter;
        }
        LoginContextUtil lcu = null;
        try {
            lcu = new LoginContextUtil(username, password);
        }
        catch (LoginException ex) {
            log.warn((Object)("Login failed for user '" + username + "'!"));
            throw ex;
        }
        boolean bl = admin = lcu.isSuperAdmin() || lcu.isUserInRole("section.airportmapgenerator_admin");
        if (!admin && !lcu.isUserInRole("section.airportmapgenerator")) {
            throw new UserNotInRoleException("User '" + username + "' is not in role " + "section.airportmapgenerator" + "!");
        }
        Long airportId = -1L;
        boolean sendDeleted = false;
        boolean sendGeoFencing = false;
        boolean sendNonGeoFencing = false;
        Object airportIdParameter = call.getParameter("airportId");
        if (airportIdParameter != null) {
            log.debug((Object)("Found airportId '" + airportId + "' in parameters."));
            airportId = Long.parseLong(airportIdParameter.toString());
        } else {
            airportId = null;
        }
        Object sendDeletedParameter = call.getParameter("sendDeleted");
        sendDeleted = sendDeletedParameter != null ? Boolean.parseBoolean(sendDeletedParameter.toString()) : lcu.isSuperAdmin() || lcu.isUserInRole("section.airportmapgenerator_admin");
        Object sendNonGeoFencingParameter = call.getParameter("sendAirportMapAreas");
        if (sendNonGeoFencingParameter != null) {
            sendNonGeoFencing = Boolean.parseBoolean(sendNonGeoFencingParameter.toString());
        }
        if ((sendGeoFencingParameter = call.getParameter("sendGeoFencingAreas")) != null) {
            sendGeoFencing = Boolean.parseBoolean(sendGeoFencingParameter.toString());
        }
        if (sendNonGeoFencing && sendGeoFencing) {
            log.error((Object)"Client wants to get both, geo fencing and airportmap areas. This isn't possible, will send only airportmap areas!");
            sendGeoFencing = false;
        } else if (!sendNonGeoFencing && !sendGeoFencing) {
            log.warn((Object)"Client wants to get none of the area types, neither geo fencing nor airportmap areas!?!");
        } else {
            if (!admin && sendNonGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.airportmap")) {
                throw new UserNotInRoleException("User '" + username + "' is not in the needed role for this operation: " + "section.airportmapgenerator.airportmap");
            }
            if (!admin && sendGeoFencing && !lcu.isUserInRole("section.airportmapgenerator.geofencing")) {
                throw new UserNotInRoleException("User '" + username + "' is not in the needed role for this operation: " + "section.airportmapgenerator.geofencing");
            }
        }
        if (airportId != null) {
            log.debug((Object)("Fetching areas for airportId '" + airportId + "' ..."));
            areaEntities = this.areaHome.findOrderedByPriorityByAirport(airportId.longValue());
        } else {
            log.debug((Object)"Fetching areas which aren't allocated to any unit id ...");
            areaEntities = this.areaHome.findAreasNotAllocatedToUnit();
        }
        for (Area area : areaEntities) {
            AreaValue areaValue = area.getAreaValue();
            int areaKey = areaValue.getAreaId();
            String areaName = areaValue.getArea();
            String areaDesc = areaValue.getDescription();
            int areaPriority = areaValue.getPriority();
            boolean areaDeleted = areaValue.getDeleted();
            boolean areaGeoFencing = areaValue.getIsGeofencing();
            Collection areaPoints = this.readPointsForArea(areaKey);
            if (!sendDeleted && areaDeleted || !sendGeoFencing && areaGeoFencing || !sendNonGeoFencing && !areaGeoFencing) continue;
            HashMap<String, Object> areaValues = new HashMap<String, Object>();
            areaValues.put("area_name", areaName);
            areaValues.put("area_desc", areaDesc);
            areaValues.put("area_prio", areaPriority);
            areaValues.put("area_del", areaDeleted);
            areaValues.put("area_geoFenc", areaGeoFencing);
            areaValues.put("area_points", areaPoints);
            areasHashMap.put(areaKey, areaValues);
        }
        log.debug((Object)("Send " + areasHashMap.size() + " area(s) to client."));
        return areasHashMap;
    }

    public String getMethodName() {
        return "GetAreas";
    }

    public void init() throws Exception {
        this.areaHome = AreaUtil.getHome();
        this.areaPointsHome = AreaPointsUtil.getHome();
        this.configuration = ConfigurationUtil.getHome().create();
        this.airportMapGeneratorConfig = AirportMapGeneratorUtil.getMBean();
    }

    private Collection readPointsForArea(int areaId) throws ServletException {
        ArrayList<Point> areaPoints = new ArrayList<Point>();
        try {
            for (AreaPoints areaPoint : this.areaPointsHome.findByArea(areaId)) {
                areaPoints.add(new Point(areaPoint.getAreaPointsValue().getLongitude(), areaPoint.getAreaPointsValue().getLatitude()));
            }
        }
        catch (Exception ex) {
            throw new ServletException("Exception throwing during creating a points collection", (Throwable)ex);
        }
        return areaPoints;
    }

    public boolean isDisabled() {
        return this.airportMapGeneratorConfig.isClientsDisabled();
    }
}

