/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.servlet.dataOut.rpc;

import de.proveo.util.connection.LoginResponse;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleRPCHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.SimpleXMLRPCCall;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.GetAPReplayUnitTreeHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.GetAPVisibleUnitTreeHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.generator.GetAreasHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.generator.GetUnitGroupsTreeHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.airportmap.generator.SetAreasHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.general.LoginHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.AddConfigurationToInfomanRemoteUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.BeginInfomanUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.CreatePlanedInfomanUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetAvailableInfomanSoftwareHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetCurrentInfomanSetupHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetInfomanSoftwareForPlanedUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetPlannedInfomanRemoteUpdatesHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.GetUnitTreeHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.InfomanUpdateDoneHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.RemoveInfomanSoftwareFromPlanedUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.SetInfomanSoftwareForPlanedUpdateHandler;
import de.proveo.wwt.logic.servlet.dataOut.rpc.infoman.UpdateScheduledInfomanUpdateHandler;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.beans.DefaultPersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleXMLRPCServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(SimpleXMLRPCServlet.class);
    private static final long serialVersionUID = 8812540280773063969L;
    private Map<String, SimpleRPCHandler> handlers = new HashMap<String, SimpleRPCHandler>();

    public String getServletInfo() {
        return "Simple XML RPC Servlet";
    }

    protected void add(SimpleRPCHandler handler) {
        this.handlers.put(handler.getMethodName(), handler);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.add(new LoginHandler());
        this.add(new AddConfigurationToInfomanRemoteUpdateHandler());
        this.add(new BeginInfomanUpdateHandler());
        this.add(new CreatePlanedInfomanUpdateHandler());
        this.add(new GetAvailableInfomanSoftwareHandler());
        this.add(new GetCurrentInfomanSetupHandler());
        this.add(new GetInfomanSoftwareForPlanedUpdateHandler());
        this.add(new GetPlannedInfomanRemoteUpdatesHandler());
        this.add(new GetUnitTreeHandler());
        this.add(new InfomanUpdateDoneHandler());
        this.add(new RemoveInfomanSoftwareFromPlanedUpdateHandler());
        this.add(new SetInfomanSoftwareForPlanedUpdateHandler());
        this.add(new UpdateScheduledInfomanUpdateHandler());
        this.add(new GetAPVisibleUnitTreeHandler());
        this.add(new GetAPReplayUnitTreeHandler());
        this.add(new GetUnitGroupsTreeHandler());
        this.add(new GetAreasHandler());
        this.add(new SetAreasHandler());
        for (SimpleRPCHandler h : this.handlers.values()) {
            try {
                h.init();
            }
            catch (Throwable ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("runs during init handler " + h + "/'" + h.getMethodName() + "' into"), ex);
                }
                throw new ServletException(ex);
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        throw new ServletException("HTTP GET is not supported");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SimpleRPCHandler handler;
        String callerMethod;
        SimpleXMLRPCCall call;
        Object result;
        block15: {
            result = null;
            Object in = null;
            String contentEncoding = request.getHeader("Content-Encoding");
            in = contentEncoding != null && contentEncoding.equals("gzip") ? new GZIPInputStream((InputStream)request.getInputStream()) : request.getInputStream();
            XMLDecoder decoder = new XMLDecoder((InputStream)in);
            call = (SimpleXMLRPCCall)decoder.readObject();
            decoder.close();
            callerMethod = call.getMethod();
            if (callerMethod == null) {
                callerMethod = "";
            }
            if ((handler = this.handlers.get(callerMethod)) == null) {
                throw new ServletException("unkown method: " + callerMethod);
            }
            if (handler.isDisabled()) {
                response.sendError(503);
                return;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("callerMethod: " + callerMethod));
            }
            if (!callerMethod.equals("Login")) {
                try {
                    LoginHandler loginHandler = new LoginHandler();
                    loginHandler.init();
                    Object ret = loginHandler.execute(call);
                    if (ret == null) {
                        throw new LoginException("Login returned a null LoginResponse!");
                    }
                    if (ret instanceof LoginResponse) {
                        LoginResponse loginResponse = (LoginResponse)ret;
                        if (!loginResponse.isAccessPermitted()) {
                            throw new LoginException("Login not permitted!");
                        }
                        break block15;
                    }
                    throw new LoginException("Login returned a unknown value!");
                }
                catch (LoginException ex) {
                    log.error((Object)"Login failed", (Throwable)ex);
                    result = ex;
                }
                catch (Throwable ex) {
                    log.error((Object)"Error while trying to login", ex);
                    result = ex;
                }
            }
        }
        if (result == null) {
            try {
                result = handler.execute(call);
            }
            catch (Throwable ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("runs during execute '" + callerMethod + "' into"), ex);
                }
                result = ex;
            }
        }
        response.setContentType("text/xml;charset=UTF-8");
        XMLEncoder resultEncoder = new XMLEncoder((OutputStream)response.getOutputStream());
        resultEncoder.setPersistenceDelegate(UnitTreeNode.class, new DefaultPersistenceDelegate(new String[]{"unitModelValue", "unitIdentityValue", "unitTypeIdentityValue"}));
        resultEncoder.writeObject(result);
        resultEncoder.close();
    }
}

